/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.mtjava.math.interpolation;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mr_toad.lib.mtjava.math.interpolation.Interpolation;
import com.mr_toad.lib.mtjava.math.interpolation.InterpolationContext;
import com.mr_toad.lib.mtjava.math.interpolation.Interpolations;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;

public final class HermiteInterpolation
implements Interpolation {
    private Tension tension = Tension.DEFAULT;
    private float bias = 0.0f;

    @Override
    public float interpolate(InterpolationContext ctx) {
        float x2 = Mth.m_14207_((float)ctx.x());
        float x3 = x2 * ctx.x();
        float tension = this.tension.getValue();
        float nTension = 1.0f - tension;
        float pBias = 1.0f + this.bias;
        float nBias = 1.0f - this.bias;
        float m1 = 0.5f * nTension * ((ctx.current() - ctx.last()) * pBias + (ctx.next() - ctx.current()) * nBias);
        float m2 = 0.5f * nTension * ((ctx.next() - ctx.current()) * pBias + (ctx.postNext() - ctx.next()) * nBias);
        float h00 = Mth.m_14179_((float)x3, (float)Mth.m_14179_((float)x2, (float)1.0f, (float)-3.0f), (float)2.0f);
        float h10 = Mth.m_14179_((float)x3, (float)Mth.m_14179_((float)x2, (float)0.0f, (float)-2.0f), (float)1.0f);
        float h01 = Mth.m_14179_((float)x3, (float)Mth.m_14179_((float)x2, (float)0.0f, (float)3.0f), (float)-2.0f);
        float h11 = Mth.m_14179_((float)x3, (float)Mth.m_14179_((float)x2, (float)0.0f, (float)-1.0f), (float)1.0f);
        return h00 * ctx.current() + h10 * m1 + h01 * ctx.next() + h11 * m2;
    }

    @Override
    public String name() {
        return "hermite";
    }

    @Override
    public Codec<Interpolation> codec() {
        return RecordCodecBuilder.create(instance -> instance.group((App)Codec.BYTE.fieldOf("id").forGetter(Interpolations.INTERPOLATIONS::getIdOrThrow), (App)Tension.CODEC.fieldOf("tension").forGetter(g -> ((HermiteInterpolation)g).getTension()), (App)Codec.FLOAT.fieldOf("bias").forGetter(g -> Float.valueOf(((HermiteInterpolation)g).getBias()))).apply((Applicative)instance, (id, tens, bias) -> {
            HermiteInterpolation interpolation = new HermiteInterpolation();
            interpolation.setTension((Tension)((Object)((Object)tens)));
            interpolation.setBias(bias.floatValue());
            return interpolation;
        }));
    }

    public Tension getTension() {
        return this.tension;
    }

    public float getBias() {
        return this.bias;
    }

    public void setTension(Tension tension) {
        this.tension = tension;
    }

    public void setBias(float bias) {
        this.bias = bias;
    }

    @MethodsReturnNonnullByDefault
    public static enum Tension implements StringRepresentable
    {
        HIGH(1.0f),
        DEFAULT(0.5f),
        NORMAL(0.0f),
        LOW(-0.5f),
        EXTREME_LOW(-1.0f);

        private static final Codec<Tension> CODEC;
        private final float value;

        private Tension(float value) {
            this.value = value;
        }

        public float getValue() {
            return this.value;
        }

        public String m_7912_() {
            return Float.toString(this.getValue());
        }

        public Component symbol() {
            return Component.m_237113_((String)this.m_7912_());
        }

        static {
            CODEC = StringRepresentable.m_216439_(Tension::values);
        }
    }
}

