/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.mtjava.math.geo;

import com.mojang.serialization.Codec;
import com.mr_toad.lib.mtjava.math.vec.Vec3d;
import com.mr_toad.lib.mtjava.math.vec.Vec3f;
import com.mr_toad.lib.mtjava.math.vec.Vec3i;
import com.mr_toad.lib.mtjava.math.vec.base.DoubleVec;
import com.mr_toad.lib.mtjava.math.vec.base.FloatVec;
import com.mr_toad.lib.mtjava.math.vec.base.IntVec;
import com.mr_toad.lib.mtjava.util.func.TriFunction;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.ChunkPos;
import org.joml.Quaterniond;
import org.joml.Quaternionf;

@MethodsReturnNonnullByDefault
public enum Axis implements StringRepresentable
{
    X("x", (x, y, z) -> x, (x, y, z) -> x),
    Y("y", (x, y, z) -> y, (x, y, z) -> y),
    Z("z", (x, y, z) -> z, (x, y, z) -> z);

    public static final Codec<Axis> CODEC;
    private final String name;
    private final TriFunction<Float, Float, Float, Float> choosef;
    private final TriFunction<Double, Double, Double, Double> choosed;

    private Axis(String name, TriFunction<Float, Float, Float, Float> choosef, TriFunction<Double, Double, Double, Double> choosed) {
        this.name = name;
        this.choosef = choosef;
        this.choosed = choosed;
    }

    public static Axis byVanilla(Direction.Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> X;
            case Direction.Axis.Y -> Y;
            case Direction.Axis.Z -> Z;
        };
    }

    public String m_7912_() {
        return this.name;
    }

    public float get(float x, float y, float z) {
        return this.choosef.apply(Float.valueOf(x), Float.valueOf(y), Float.valueOf(z)).floatValue();
    }

    public double get(double x, double y, double z) {
        return this.choosed.apply(x, y, z);
    }

    public Vec3f directionf() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case X -> new Vec3f(1.0f, 0.0f, 0.0f);
            case Y -> new Vec3f(0.0f, 1.0f, 0.0f);
            case Z -> new Vec3f(0.0f, 0.0f, 1.0f);
        };
    }

    public Vec3d directiond() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case X -> new Vec3d(1.0, 0.0, 0.0);
            case Y -> new Vec3d(0.0, 1.0, 0.0);
            case Z -> new Vec3d(0.0, 0.0, 1.0);
        };
    }

    public Quaternionf counterclockwiseDeg(float v) {
        return this.clockwiseDeg(-v);
    }

    public Quaterniond counterclockwiseDeg(double v) {
        return this.clockwiseDeg(-v);
    }

    public Quaternionf clockwiseDeg(float v) {
        return this.clockwise(v * 57.295776f);
    }

    public Quaterniond clockwiseDeg(double v) {
        return this.clockwise(v * 57.2957763671875);
    }

    public Quaternionf counterclockwise(float v) {
        return this.clockwise(-v);
    }

    public Quaterniond counterclockwise(double v) {
        return this.clockwise(-v);
    }

    public Quaternionf clockwise(float v) {
        Quaternionf quaternionf = new Quaternionf();
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case X -> quaternionf.rotateX(v);
            case Y -> quaternionf.rotateY(v);
            case Z -> quaternionf.rotateZ(v);
        };
    }

    public Quaterniond clockwise(double v) {
        Quaterniond quaterniond = new Quaterniond();
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case X -> quaterniond.rotateX(v);
            case Y -> quaterniond.rotateY(v);
            case Z -> quaterniond.rotateZ(v);
        };
    }

    public int get(SectionPos pos) {
        return this.getMoj3I(pos);
    }

    public int get(ChunkPos pos) {
        return this.get(pos.m_45615_());
    }

    public int get(BlockPos pos) {
        return this.getMoj3I(pos);
    }

    public int get(net.minecraft.core.Vec3i pos) {
        return this.getMoj3I(pos);
    }

    public double get(Position position) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case X -> position.m_7096_();
            case Y -> position.m_7098_();
            case Z -> position.m_7094_();
        };
    }

    public <V extends FloatVec<V>> float get(V vec) {
        if (vec.length() == 0.0f) {
            return 0.0f;
        }
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case X -> vec.get(0);
            case Y -> {
                if (vec.size() < 2) {
                    yield 0.0f;
                }
                yield vec.get(1);
            }
            case Z -> vec.size() < 3 ? 0.0f : vec.get(2);
        };
    }

    public <V extends DoubleVec<V>> double get(V vec) {
        if (vec.length() == 0.0) {
            return 0.0;
        }
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case X -> vec.get(0);
            case Y -> {
                if (vec.size() < 2) {
                    yield 0.0;
                }
                yield vec.get(1);
            }
            case Z -> vec.size() < 3 ? 0.0 : vec.get(2);
        };
    }

    public <V extends IntVec<V>> int get(V vec) {
        if (vec.length() == 0) {
            return 0;
        }
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case X -> vec.get(0);
            case Y -> {
                if (vec.size() < 2) {
                    yield 0;
                }
                yield vec.get(1);
            }
            case Z -> vec.size() < 3 ? 0 : vec.get(2);
        };
    }

    public Direction.Plane getPlane() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case X, Z -> Direction.Plane.HORIZONTAL;
            case Y -> Direction.Plane.VERTICAL;
        };
    }

    public Direction.Axis vanilla() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case X -> Direction.Axis.X;
            case Y -> Direction.Axis.Y;
            case Z -> Direction.Axis.Z;
        };
    }

    public com.mojang.math.Axis mojMath(Direction.AxisDirection axisDirection) {
        return this.mojMath(axisDirection == Direction.AxisDirection.NEGATIVE);
    }

    public com.mojang.math.Axis mojMath(boolean negative) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case X -> {
                if (negative) {
                    yield com.mojang.math.Axis.f_252495_;
                }
                yield com.mojang.math.Axis.f_252529_;
            }
            case Y -> {
                if (negative) {
                    yield com.mojang.math.Axis.f_252392_;
                }
                yield com.mojang.math.Axis.f_252436_;
            }
            case Z -> negative ? com.mojang.math.Axis.f_252393_ : com.mojang.math.Axis.f_252403_;
        };
    }

    public Vec3f set(Vec3f target, float t) {
        switch (this) {
            case X: {
                target.setX(t);
                break;
            }
            case Y: {
                target.setY(t);
                break;
            }
            case Z: {
                target.setZ(t);
            }
        }
        return target;
    }

    public Vec3d set(Vec3d target, double t) {
        switch (this) {
            case X: {
                target.setX(t);
                break;
            }
            case Y: {
                target.setY(t);
                break;
            }
            case Z: {
                target.setZ(t);
            }
        }
        return target;
    }

    public Vec3i set(Vec3i target, int t) {
        switch (this) {
            case X: {
                target.setX(t);
                break;
            }
            case Y: {
                target.setY(t);
                break;
            }
            case Z: {
                target.setZ(t);
            }
        }
        return target;
    }

    private <P extends net.minecraft.core.Vec3i> int getMoj3I(P pos) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case X -> pos.m_123341_();
            case Y -> pos.m_123342_();
            case Z -> pos.m_123343_();
        };
    }

    public boolean isVertical() {
        return this == Y;
    }

    public boolean isHorizontal() {
        return this == X || this == Z;
    }

    static {
        CODEC = StringRepresentable.m_216439_(Axis::values);
    }
}

