/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.mtjava.floats;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.mr_toad.lib.mtjava.floats.func.FloatFunction;
import com.mr_toad.lib.mtjava.floats.func.FloatSupplier;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.floats.Float2IntFunction;
import it.unimi.dsi.fastutil.floats.FloatConsumer;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Supplier;
import java.util.stream.Stream;

public final class OptionalFloat {
    private static final OptionalFloat EMPTY = new OptionalFloat();
    private final boolean isPresent;
    private final float value;

    private OptionalFloat() {
        this.isPresent = false;
        this.value = Float.NaN;
    }

    public static OptionalFloat empty() {
        return EMPTY;
    }

    private OptionalFloat(float value) {
        this.isPresent = true;
        this.value = value;
    }

    public static OptionalFloat of(float value) {
        return new OptionalFloat(value);
    }

    public float getAsFloat() {
        if (!this.isPresent) {
            throw new NoSuchElementException("No target present");
        }
        return this.value;
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public boolean isEmpty() {
        return !this.isPresent;
    }

    public void ifPresent(FloatConsumer action) {
        if (this.isPresent) {
            action.accept(this.value);
        }
    }

    public void ifPresentOrElse(FloatConsumer action, Runnable emptyAction) {
        if (this.isPresent) {
            action.accept(this.value);
        } else {
            emptyAction.run();
        }
    }

    public float orElse(float other) {
        return this.isPresent ? this.value : other;
    }

    public float orElseGet(FloatSupplier supplier) {
        return this.isPresent ? this.value : supplier.getAsFloat();
    }

    public float orElseThrow() {
        if (!this.isPresent) {
            throw new NoSuchElementException("No target present");
        }
        return this.value;
    }

    public <X extends Throwable> float orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.isPresent) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public Stream<Float> stream() {
        if (this.isPresent) {
            return Stream.of(Float.valueOf(this.value));
        }
        return Stream.empty();
    }

    public OptionalFloat map(Float2FloatFunction mapper) {
        Preconditions.checkNotNull((Object)mapper);
        if (!this.isPresent()) {
            return OptionalFloat.empty();
        }
        return OptionalFloat.of(((Float)mapper.apply((Object)Float.valueOf(this.value))).floatValue());
    }

    public OptionalInt map(Float2IntFunction mapper) {
        Preconditions.checkNotNull((Object)mapper);
        if (!this.isPresent()) {
            return OptionalInt.empty();
        }
        return OptionalInt.of((Integer)mapper.apply((Object)Float.valueOf(this.value)));
    }

    public <F> Optional<F> map(FloatFunction<F> mapper) {
        Preconditions.checkNotNull(mapper);
        if (!this.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(mapper.apply(this.value));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OptionalFloat)) return false;
        OptionalFloat other = (OptionalFloat)obj;
        if (this.isPresent && other.isPresent) {
            if (Float.compare(this.value, other.value) != 0) return false;
            return true;
        } else if (this.isPresent != other.isPresent) return false;
        return true;
    }

    public int hashCode() {
        return this.isPresent ? Float.hashCode(this.value) : 0;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add(this.isPresent ? String.format("OptionalFloat[%s]", Float.valueOf(this.value)) : "Empty", this.value).toString();
    }
}

