/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.mtjava.concurrent;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import it.unimi.dsi.fastutil.floats.FloatBinaryOperator;
import it.unimi.dsi.fastutil.floats.FloatUnaryOperator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public final class AtomicFloat
extends Number
implements Serializable {
    private static final long serialVersionUID = 0L;
    private volatile int value;
    private static final AtomicIntegerFieldUpdater<AtomicFloat> UPDATER = AtomicIntegerFieldUpdater.newUpdater(AtomicFloat.class, "value");

    public AtomicFloat(float initialValue) {
        this.value = Float.floatToIntBits(initialValue);
    }

    public AtomicFloat() {
    }

    public float get() {
        return Float.intBitsToFloat(this.value);
    }

    public void set(float newValue) {
        this.value = Float.floatToRawIntBits(newValue);
    }

    public void lazySet(float newValue) {
        int next = Float.floatToIntBits(newValue);
        UPDATER.lazySet(this, next);
    }

    public float getAndSet(float newValue) {
        int next = Float.floatToIntBits(newValue);
        return Float.intBitsToFloat(UPDATER.getAndSet(this, next));
    }

    public boolean compareAndSet(float expect, float update) {
        return UPDATER.compareAndSet(this, Float.floatToRawIntBits(expect), Float.floatToRawIntBits(update));
    }

    public boolean weakCompareAndSet(float expect, float update) {
        return UPDATER.weakCompareAndSet(this, Float.floatToRawIntBits(expect), Float.floatToRawIntBits(update));
    }

    @CanIgnoreReturnValue
    public float getAndAdd(float delta) {
        return this.getAndAccumulate(delta, Float::sum);
    }

    @CanIgnoreReturnValue
    public float addAndGet(float delta) {
        return this.accumulateAndGet(delta, Float::sum);
    }

    @CanIgnoreReturnValue
    public float getAndAccumulate(float x, FloatBinaryOperator accumulatorFunction) {
        Preconditions.checkNotNull((Object)accumulatorFunction);
        return this.getAndUpdate(oldValue -> accumulatorFunction.apply(oldValue, x));
    }

    @CanIgnoreReturnValue
    public float accumulateAndGet(float x, FloatBinaryOperator accumulatorFunction) {
        Preconditions.checkNotNull((Object)accumulatorFunction);
        return this.updateAndGet(oldValue -> accumulatorFunction.apply(oldValue, x));
    }

    @CanIgnoreReturnValue
    public float getAndUpdate(FloatUnaryOperator updateFunction) {
        float currentVal;
        float nextVal;
        int next;
        int current;
        while (!UPDATER.compareAndSet(this, current = this.value, next = Float.floatToRawIntBits(nextVal = updateFunction.apply(currentVal = Float.intBitsToFloat(current))))) {
        }
        return currentVal;
    }

    @CanIgnoreReturnValue
    public float updateAndGet(FloatUnaryOperator updateFunction) {
        float currentVal;
        float nextVal;
        int next;
        int current;
        while (!UPDATER.compareAndSet(this, current = this.value, next = Float.floatToRawIntBits(nextVal = updateFunction.apply(currentVal = Float.intBitsToFloat(current))))) {
        }
        return nextVal;
    }

    public String toString() {
        return Float.toString(this.get());
    }

    @Override
    public int intValue() {
        return (int)this.get();
    }

    @Override
    public long longValue() {
        return (long)this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }

    @Override
    public float floatValue() {
        return this.get();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeFloat(this.get());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.set(s.readFloat());
    }
}

