/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.mtjava.bytes;

import com.mr_toad.lib.mtjava.bytes.func.ByteSupplier;
import it.unimi.dsi.fastutil.bytes.ByteConsumer;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import java.util.stream.IntStream;

public final class OptionalByte {
    private static final OptionalByte EMPTY = new OptionalByte();
    private final boolean isPresent;
    private final byte value;

    private OptionalByte() {
        this.isPresent = false;
        this.value = 0;
    }

    private OptionalByte(byte value) {
        this.isPresent = true;
        this.value = value;
    }

    public static OptionalByte empty() {
        return EMPTY;
    }

    public static OptionalByte of(byte value) {
        return new OptionalByte(value);
    }

    public byte getAsByte() {
        if (!this.isPresent) {
            throw new NoSuchElementException("No target present");
        }
        return this.value;
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public boolean isEmpty() {
        return !this.isPresent;
    }

    public void ifPresent(ByteConsumer action) {
        if (this.isPresent) {
            action.accept(this.value);
        }
    }

    public void ifPresentOrElse(ByteConsumer action, Runnable emptyAction) {
        if (this.isPresent) {
            action.accept(this.value);
        } else {
            emptyAction.run();
        }
    }

    public IntStream stream() {
        if (this.isPresent) {
            return IntStream.of((int)this.value);
        }
        return IntStream.empty();
    }

    public byte orElse(byte other) {
        return this.isPresent ? this.value : other;
    }

    public byte orElseGet(ByteSupplier supplier) {
        return this.isPresent ? this.value : supplier.getAsByte();
    }

    public byte orElseThrow() {
        if (!this.isPresent) {
            throw new NoSuchElementException("No target present");
        }
        return this.value;
    }

    public <X extends Throwable> byte orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.isPresent) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OptionalByte)) return false;
        OptionalByte other = (OptionalByte)obj;
        if (this.isPresent && other.isPresent) {
            if (this.value != other.value) return false;
            return true;
        } else if (this.isPresent != other.isPresent) return false;
        return true;
    }

    public int hashCode() {
        return this.isPresent ? Byte.hashCode(this.value) : 0;
    }

    public String toString() {
        return this.isPresent ? String.format("OptionalByte[%s]", this.value) : "OptionalByte.empty";
    }
}

