/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.core.mixin.catalogue;

import com.mr_toad.lib.api.integration.BuiltInIntegrations;
import com.mr_toad.lib.core.ToadLib;
import com.mrcrayfish.catalogue.client.ForgeModData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.forgespi.language.IModInfo;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ForgeModData.class}, remap=false)
public abstract class ForgeModDataMixin {
    @Shadow
    @Final
    private IModInfo info;

    @Shadow
    public abstract String getModId();

    @Inject(method={"hasConfig"}, at={@At(value="TAIL")}, cancellable=true)
    public void hasToadConfig(CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)cir.getReturnValue()).booleanValue() && BuiltInIntegrations.hasToadConfig(this.getModId())) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"openConfigScreen"}, at={@At(value="HEAD")}, cancellable=true)
    public void openToadConfigScreen(Screen parent, CallbackInfo ci) {
        ConfigScreenHandler.getScreenFactoryFor((IModInfo)this.info).map(f -> (Screen)f.apply(Minecraft.m_91087_(), parent)).ifPresentOrElse(newScreen -> Minecraft.m_91087_().m_91152_(newScreen), () -> {
            ToadLib.LOGGER.debug(ToadLib.CONFIG, "Trying to load config screen for catalogue...");
            BuiltInIntegrations.getConfigScreen(this.getModId(), parent).ifPresentOrElse(screen -> {
                ToadLib.LOGGER.debug(ToadLib.CONFIG, "Loaded config screen to catalogue for '{}'", (Object)this.getModId());
                Minecraft.m_91087_().m_91152_((Screen)screen);
            }, () -> ToadLib.LOGGER.debug(ToadLib.CONFIG, "Failed to load screen for catalogue of '{}'", (Object)this.getModId()));
        });
        ci.cancel();
    }
}

