/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.core.mixin;

import com.google.common.collect.Lists;
import com.mr_toad.lib.api.event.ToadEventFactory;
import com.mr_toad.lib.api.event.custom.RegisterCustomSpawnersEvent;
import com.mr_toad.lib.api.event.custom.RegisterSavedDataEvent;
import com.mr_toad.lib.api.util.CustomSpawnerHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.RandomSequences;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLevel.class})
public abstract class ServerLevelMixin
extends Level
implements WorldGenLevel {
    @Mutable
    @Shadow
    @Final
    private List<CustomSpawner> f_8558_;

    protected ServerLevelMixin(WritableLevelData data, ResourceKey<Level> key, RegistryAccess access, Holder<DimensionType> dimensionType, Supplier<ProfilerFiller> profilerFiller, boolean aB01, boolean aB02, long s, int i0) {
        super(data, key, access, dimensionType, profilerFiller, aB01, aB02, s, i0);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void toadlibInServerLevelInit(MinecraftServer server, Executor executor, LevelStorageSource.LevelStorageAccess access, ServerLevelData serverLevelData, ResourceKey<Level> dim, LevelStem stem, ChunkProgressListener chunkProgressListener, boolean b, long gameTime, List<CustomSpawner> spawners, boolean b2, RandomSequences sequences, CallbackInfo ci) {
        MinecraftForge.EVENT_BUS.post((Event)new RegisterSavedDataEvent((ServerLevel)this));
        ArrayList customSpawners = Lists.newArrayList(spawners);
        RegisterCustomSpawnersEvent event = new RegisterCustomSpawnersEvent();
        MinecraftForge.EVENT_BUS.post((Event)event);
        customSpawners.addAll(event.getSpawners().stream().filter(holder -> holder.dim() == dim).map(CustomSpawnerHolder::spawner).toList());
        this.f_8558_ = customSpawners;
    }

    @Inject(method={"tickChunk"}, at={@At(value="TAIL")})
    public void eventChunkEnd(LevelChunk chunk, int i0, CallbackInfo ci) {
        ToadEventFactory.onChunkTickEnd(this.m_6018_(), chunk);
    }
}

