/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.core;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mr_toad.lib.api.client.init.ConfigEntryWidgetsRegistry;
import com.mr_toad.lib.api.client.init.EaseWidgetSettingsRegistry;
import com.mr_toad.lib.api.client.resource.ConfigReloadListener;
import com.mr_toad.lib.api.client.utils.ToadClientUtils;
import com.mr_toad.lib.api.config.ToadConfigs;
import com.mr_toad.lib.api.entity.immune.EffectImmuneStorage;
import com.mr_toad.lib.api.integration.BuiltInIntegrations;
import com.mr_toad.lib.core.config.ToadLibConfig;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

@Mod(value="toadlib")
public class ToadLib {
    public static final String PROTOCOL = "1.3";
    public static final String MODID = "toadlib";
    public static final Object2ObjectMap<String, Supplier<SavedData>> SAVED_DATA_SUPPLIERS = new Object2ObjectOpenHashMap();
    public static final Marker CONFIG = MarkerFactory.getMarker((String)"ToadConfig");
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"ToadLib");
    public static final ToadLibConfig CFG = new ToadLibConfig();

    public ToadLib() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> bus.addListener(this::clientSetup));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ToadConfigs.create(MODID, CFG);
            EaseWidgetSettingsRegistry.init();
            ConfigEntryWidgetsRegistry.init();
        });
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MODID, path);
    }

    public static <D extends SavedData> Optional<Supplier<D>> findSavedData(String file) {
        try {
            Supplier supplier = (Supplier)SAVED_DATA_SUPPLIERS.get((Object)file);
            if (supplier == null) {
                LOGGER.error("Saved data with file name '{}', doesn't exists or server level not initialized!", (Object)file);
                return Optional.empty();
            }
            return Optional.of(Suppliers.memoize((Supplier)supplier));
        }
        catch (Exception e) {
            LOGGER.error("Error during get '{}' saved data!", (Object)file, (Object)e);
            return Optional.empty();
        }
    }

    @ParametersAreNonnullByDefault
    @Mod.EventBusSubscriber(modid="toadlib", value={Dist.CLIENT})
    public static class Client {
        @SubscribeEvent
        public static void addConfigButtons(ScreenEvent.Init event) {
            if (((Boolean)ToadLib.CFG.showConfigButton.get()).booleanValue() && !BuiltInIntegrations.CATALOGUE.isLoaded() && (event.getScreen() instanceof TitleScreen || event.getScreen() instanceof PauseScreen)) {
                event.addListener((GuiEventListener)ToadClientUtils.createConfigButton(event.getScreen().f_96543_ / 2 + 104, event.getScreen().f_96544_ / 4 + 96, event.getScreen()));
            }
        }
    }

    @Mod.EventBusSubscriber(modid="toadlib", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientBus {
        @SubscribeEvent
        public static void registerReloadListeners(RegisterClientReloadListenersEvent event) {
            event.registerReloadListener((PreparableReloadListener)new ConfigReloadListener());
        }
    }

    @Mod.EventBusSubscriber(modid="toadlib", value={Dist.DEDICATED_SERVER})
    public static class Server {
        @SubscribeEvent
        public static void onLevelLoad(LevelEvent.Load event) {
            EffectImmuneStorage.init();
        }

        @SubscribeEvent
        public static void onEffectApply(MobEffectEvent.Applicable event) {
            if (EffectImmuneStorage.isInImmuneMap(event.getEntity(), event.getEffectInstance())) {
                event.setResult(Event.Result.DENY);
            }
        }
    }
}

