/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.mixins;

import com.mr_toad.lib.api.mixins.OptionalMixin;
import com.mr_toad.lib.core.ToadLib;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import net.minecraftforge.fml.loading.LoadingModList;
import org.jetbrains.annotations.ApiStatus;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.service.MixinService;

@ApiStatus.OverrideOnly
public abstract class SupportOptionalMixinsMixinPlugin
implements IMixinConfigPlugin {
    public static final Marker TOAD_MXS = MarkerFactory.getMarker((String)"MixinsByToadLib");

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        ClassNode node;
        try {
            node = MixinService.getService().getBytecodeProvider().getClassNode(mixinClassName);
        }
        catch (IOException | ClassNotFoundException e) {
            ToadLib.LOGGER.warn(TOAD_MXS, "Class node not found", (Throwable)e);
            return false;
        }
        if (node != null && node.invisibleAnnotations != null) {
            for (AnnotationNode annotationNode : node.invisibleAnnotations) {
                if (!annotationNode.desc.equals("L" + OptionalMixin.class.getName().replace('.', '/') + ";")) continue;
                List values = annotationNode.values;
                boolean flag = values.size() < 4 || (Boolean)values.get(3) != false;
                try {
                    String name = values.get(1).toString();
                    MixinService.getService().getBytecodeProvider().getClassNode(name);
                    ToadLib.LOGGER.debug(TOAD_MXS, "Find optional mixin {}", (Object)name);
                    if (flag) continue;
                    return false;
                }
                catch (IOException | ClassNotFoundException e) {
                    ToadLib.LOGGER.warn(TOAD_MXS, "Class node not found", (Throwable)e);
                    if (!flag) continue;
                    return false;
                }
            }
        }
        return LoadingModList.get().getErrors().isEmpty();
    }

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

