/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.item;

import com.google.common.collect.Maps;
import com.mr_toad.lib.core.ToadLib;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ItemStack;

public interface ToadlyArmorItem {
    public static final HashMap<ArmorMaterial, MobEffectInstance> MATERIAL_TO_EFFECT_MAP = Maps.newHashMap();

    default public void put(ArmorMaterial material, MobEffectInstance effectInstance) {
        if (material != null && effectInstance != null) {
            MATERIAL_TO_EFFECT_MAP.put(material, effectInstance);
        } else {
            ToadLib.LOGGER.error("Material & Effect cannot be null");
        }
    }

    default public void evaluateArmorEffects(Player player) {
        if (!MATERIAL_TO_EFFECT_MAP.isEmpty()) {
            for (Map.Entry<ArmorMaterial, MobEffectInstance> entry : MATERIAL_TO_EFFECT_MAP.entrySet()) {
                ArmorMaterial mapArmorMaterial = entry.getKey();
                MobEffectInstance mapStatusEffect = entry.getValue();
                if (!this.hasCorrectArmorOn(mapArmorMaterial, player)) continue;
                this.addStatusEffectForMaterial(player, mapArmorMaterial, mapStatusEffect);
            }
        }
    }

    default public boolean hasCorrectArmorOn(ArmorMaterial material, Player player) {
        for (ItemStack armorStack : player.m_150109_().f_35975_) {
            if (armorStack.m_41720_() instanceof ArmorItem) continue;
            return false;
        }
        ArmorItem boots = (ArmorItem)player.m_150109_().m_36052_(0).m_41720_();
        ArmorItem leggings = (ArmorItem)player.m_150109_().m_36052_(1).m_41720_();
        ArmorItem chestplate = (ArmorItem)player.m_150109_().m_36052_(2).m_41720_();
        ArmorItem helmet = (ArmorItem)player.m_150109_().m_36052_(3).m_41720_();
        return helmet.m_40401_() == material && chestplate.m_40401_() == material && leggings.m_40401_() == material && boots.m_40401_() == material;
    }

    default public void addStatusEffectForMaterial(Player player, ArmorMaterial mapArmorMaterial, MobEffectInstance mapStatusEffect) {
        boolean hasPlayerEffect = player.m_21023_(mapStatusEffect.m_19544_());
        if (this.hasCorrectArmorOn(mapArmorMaterial, player) && !hasPlayerEffect) {
            player.m_7292_(new MobEffectInstance(mapStatusEffect.m_19544_(), mapStatusEffect.m_19557_(), mapStatusEffect.m_19564_()));
        }
    }
}

