/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.integration;

import com.mr_toad.lib.api.client.screen.config.ToadConfigScreen;
import com.mr_toad.lib.api.config.ToadConfig;
import com.mr_toad.lib.api.integration.Integration;
import com.mr_toad.lib.core.ToadLib;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.gui.screens.Screen;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.ApiStatus;

public class BuiltInIntegrations {
    private static final Object2ObjectMap<String, Function<Screen, ToadConfigScreen>> CATALOGUE_CONFIGS = new Object2ObjectOpenHashMap();
    public static final Integration CATALOGUE = () -> "catalogue";
    public static final Integration QUARK = () -> "quark";
    public static final Integration CREATE = () -> "create";

    @ApiStatus.Internal
    public static Optional<ToadConfigScreen> getConfigScreen(String modid, Screen parent) {
        if (!CATALOGUE.isLoaded() || CATALOGUE_CONFIGS.isEmpty() || StringUtils.isEmpty((CharSequence)modid) || !CATALOGUE_CONFIGS.containsKey((Object)modid)) {
            return Optional.empty();
        }
        ToadLib.LOGGER.info(ToadLib.CONFIG, "Loaded ToadConfig for ModMenu of '{}'", (Object)modid);
        return Optional.ofNullable((ToadConfigScreen)((Object)((Function)CATALOGUE_CONFIGS.get((Object)modid)).apply(parent)));
    }

    public static boolean hasToadConfig(String modid) {
        if (!CATALOGUE.isLoaded() || CATALOGUE_CONFIGS.isEmpty()) {
            return false;
        }
        return CATALOGUE_CONFIGS.containsKey((Object)modid);
    }

    @ApiStatus.Internal
    public static <C extends ToadConfig> void setupConfig(String modid, C config) {
        if (!CATALOGUE.isLoaded() || StringUtils.isEmpty((CharSequence)modid) || config == null || CATALOGUE_CONFIGS.containsKey((Object)modid)) {
            return;
        }
        CATALOGUE_CONFIGS.put((Object)modid, parent -> new ToadConfigScreen((Screen)parent, config));
    }

    @ApiStatus.Internal
    public static Object2ObjectMap<String, Function<Screen, ToadConfigScreen>> getCatalogueConfigs() {
        return CATALOGUE_CONFIGS;
    }
}

