/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.entity.ai.goal;

import com.mr_toad.lib.api.entity.entitydata.BlowUpDataContainer;
import com.mr_toad.lib.api.util.SpawnLingeringCloudData;
import it.unimi.dsi.fastutil.floats.FloatPredicate;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class BlowUpGoal<M extends PathfinderMob>
extends Goal {
    private int oldSwell;
    private int swell;
    private int maxSwell;
    private final M mob;
    private float explosionRadius;
    private final double distToSqr;
    private final boolean shouldStopOnExplosion;
    private final boolean shouldExplodeIfNotSee;
    private final boolean invulnerableIfIgnited;
    @Nullable
    private final FloatPredicate hpPredicate;
    @Nullable
    private final SoundEvent explosionSound;
    @Nullable
    private final SpawnLingeringCloudData lingeringCloudData;
    @Nullable
    private LivingEntity target;

    public BlowUpGoal(M mob, float explosionRadius, int maxSwell, double distToSqr, boolean shouldStopOnExplosion, boolean shouldExplodeIfNotSee, boolean invulnerableIfIgnited, @Nullable FloatPredicate hpPredicate, @Nullable SoundEvent explosionSound, @Nullable SpawnLingeringCloudData lingeringCloudData) {
        this.mob = mob;
        this.explosionRadius = explosionRadius;
        this.maxSwell = maxSwell;
        this.distToSqr = distToSqr;
        this.shouldStopOnExplosion = shouldStopOnExplosion;
        this.shouldExplodeIfNotSee = shouldExplodeIfNotSee;
        this.invulnerableIfIgnited = invulnerableIfIgnited;
        this.hpPredicate = hpPredicate;
        this.explosionSound = explosionSound;
        this.lingeringCloudData = lingeringCloudData;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.shouldExplodeIfNotSee) {
            return this.canExplode() && !this.mob.m_21573_().m_26571_();
        }
        if (this.hpPredicate != null) {
            return this.canExplode() && this.hpPredicate.test(this.mob.m_21233_());
        }
        return this.canExplode();
    }

    public void m_8056_() {
        super.m_8056_();
        if (this.shouldStopOnExplosion) {
            this.mob.m_21573_().m_26573_();
        }
        this.target = this.mob.m_5448_();
        this.mob.m_21561_(true);
    }

    public void m_8041_() {
        super.m_8041_();
        this.target = null;
        this.mob.m_21561_(false);
    }

    public void m_8037_() {
        if (this.target == null) {
            ((BlowUpDataContainer)this.mob).setSwellDir(-1);
        } else if (this.mob.m_20280_((Entity)this.target) > 49.0) {
            ((BlowUpDataContainer)this.mob).setSwellDir(-1);
        } else if (!this.shouldExplodeIfNotSee && !this.mob.m_21574_().m_148306_((Entity)this.target)) {
            ((BlowUpDataContainer)this.mob).setSwellDir(-1);
        } else {
            ((BlowUpDataContainer)this.mob).setSwellDir(1);
        }
        if (this.mob.m_6084_()) {
            int $$0;
            this.oldSwell = this.swell;
            if (((BlowUpDataContainer)this.mob).isIgnited()) {
                ((BlowUpDataContainer)this.mob).setSwellDir(1);
            }
            if (this.invulnerableIfIgnited) {
                this.mob.m_6673_(this.mob.m_269291_().m_269333_(this.target));
            }
            if (($$0 = ((BlowUpDataContainer)this.mob).getSwellDir()) > 0 && this.swell == 0) {
                if (this.explosionSound != null) {
                    this.mob.m_5496_(this.explosionSound, 1.0f, 0.5f);
                }
                this.mob.m_146850_(GameEvent.f_157776_);
            }
            this.swell += $$0;
            if (this.swell < 0) {
                this.swell = 0;
            }
            if (this.swell >= this.maxSwell) {
                this.swell = this.maxSwell;
                this.explode();
            }
        }
        super.m_8037_();
    }

    public boolean m_183429_() {
        return true;
    }

    public boolean canExplode() {
        return ((BlowUpDataContainer)this.mob).getSwellDir() > 0 || this.mob.m_5448_() != null && this.mob.m_20280_((Entity)this.mob.m_5448_()) < this.distToSqr;
    }

    public float getSwelling(float sw) {
        return Mth.m_14179_((float)sw, (float)this.oldSwell, (float)this.swell) / (float)(this.maxSwell - 2);
    }

    public void saveBlowUpData(CompoundTag nbt) {
        nbt.m_128376_("Fuse", (short)this.maxSwell);
        nbt.m_128350_("ExplosionRadius", this.explosionRadius);
        nbt.m_128379_("Ignited", ((BlowUpDataContainer)this.mob).isIgnited());
    }

    public void loadBlowUpData(CompoundTag nbt) {
        if (nbt.m_128425_("Fuse", 99)) {
            this.maxSwell = nbt.m_128448_("Fuse");
        }
        if (nbt.m_128425_("ExplosionRadius", 99)) {
            this.explosionRadius = nbt.m_128457_("ExplosionRadius");
        }
        if (nbt.m_128471_("Ignited")) {
            ((BlowUpDataContainer)this.mob).ignite();
        }
    }

    private void explode() {
        if (!this.mob.m_9236_().m_5776_()) {
            this.mob.m_9236_().m_254849_(this.mob, this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_(), this.explosionRadius, Level.ExplosionInteraction.MOB);
            this.mob.m_146870_();
            if (this.lingeringCloudData != null) {
                this.lingeringCloudData.spawn(SpawnLingeringCloudData.BY_ACTIVE_EFFECTS);
            }
        }
    }
}

