/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.db.storage;

import com.google.common.base.Objects;
import com.mr_toad.lib.core.ToadLib;
import com.mr_toad.lib.mtjava.collections.UniqueList;
import com.mr_toad.lib.mtjava.io.MTIO;
import com.mr_toad.lib.mtjava.strings.func.ToStringFunction;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.fml.loading.FMLPaths;

public abstract class AbstractGameDataNbtStorage<L> {
    public static final String ERROR_CODE = "errorcode1";
    protected final UniqueList<L> values = new UniqueList();
    private final File dir;
    private final ToStringFunction<L> flow;

    public AbstractGameDataNbtStorage(String child, ToStringFunction<L> flow) {
        this(new File(FMLPaths.GAMEDIR.get().resolve("toadlib/database").toFile(), child), flow);
    }

    public AbstractGameDataNbtStorage(File file, ToStringFunction<L> flow) {
        this.dir = file;
        this.flow = flow;
    }

    protected abstract Optional<L> load(ServerLevel var1, CompoundTag var2);

    protected abstract void save(CompoundTag var1, L var2);

    public void load(ServerLevel serverLevel) {
        File[] files = this.getDir().listFiles();
        if (files == null || files.length == 0) {
            ToadLib.LOGGER.warn("Nothing to read from '{}'", (Object)this.getDir());
        } else {
            MTIO.IO.execute(() -> Arrays.stream(files).map(File::getPath).forEach(s -> {
                if (!s.endsWith(".nbt")) {
                    ToadLib.LOGGER.error("Unknown object: '{}' in '{}'", s, (Object)this.getDir());
                } else if (s.contains(ERROR_CODE)) {
                    ToadLib.LOGGER.error("Error in: '{}'", (Object)this.getDir());
                } else {
                    try {
                        CompoundTag nbt = NbtIo.m_128937_((File)new File(this.getDir(), "/" + s + ".nbt"));
                        this.load(serverLevel, nbt).ifPresentOrElse(this.values::add, () -> ToadLib.LOGGER.error("Loaded target is null!"));
                    }
                    catch (IOException e) {
                        ToadLib.LOGGER.error("Cannot load '{}' from '{}'", s, (Object)this.getDir());
                    }
                }
            }));
        }
    }

    public final void save() {
        MTIO.IO.execute(() -> this.values.forEach(v -> {
            CompoundTag nbt = NbtUtils.m_264171_((CompoundTag)new CompoundTag());
            this.save(nbt, v);
            File file = this.getAbsolutePath(v);
            try {
                NbtIo.m_128944_((CompoundTag)nbt, (File)file);
            }
            catch (IOException e) {
                ToadLib.LOGGER.error("Cannot parse '{}' to '{}'", (Object)file, (Object)this.getDir());
            }
        }));
    }

    public UniqueList<L> getValues() {
        return this.values;
    }

    public File getDir() {
        return this.dir;
    }

    public File getAbsolutePath(L v) {
        return new File(this.getDir(), "/" + this.getFlow(v) + ".nbt");
    }

    protected String getFlow(L value) {
        return this.flow.applyAsString(value);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AbstractGameDataNbtStorage) {
            AbstractGameDataNbtStorage storage = (AbstractGameDataNbtStorage)obj;
            return Objects.equal((Object)this.getDir(), (Object)storage.getDir());
        }
        return false;
    }

    public int hashCode() {
        return this.getDir().hashCode() - 3;
    }

    public String toString() {
        return "MMNGD(" + this.getDir() + ")";
    }
}

