/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.config.util;

import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public enum PageSeparateLine {
    EQUALS('=', false),
    CIRCLE('\u25cf', true),
    EMPTY_CIRCLE('\u25cb', true),
    LINE('-', false),
    WAVE(24, '~', false);

    private final int length;
    private final char separator;
    private final boolean requireSpace;

    private PageSeparateLine(char separator, boolean requireSpace) {
        this(requireSpace ? 16 : 32, separator, requireSpace);
    }

    private PageSeparateLine(int length, char separator, boolean requireSpace) {
        this.length = length;
        this.separator = separator;
        this.requireSpace = requireSpace;
    }

    public String getFormatted() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.length; ++i) {
            builder.append(this.separator);
            if (!this.requireSpace || builder.length() >= 32) continue;
            builder.append(' ');
        }
        return builder.toString();
    }

    public boolean isRequireSpace() {
        return this.requireSpace;
    }
}

