/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.config.util;

import com.google.gson.JsonElement;
import com.mr_toad.lib.api.config.entry.ConfigEntry;
import com.mr_toad.lib.api.config.entry.type.ConfigEntryTypes;
import com.mr_toad.lib.api.config.util.HighlightWarning;
import com.mr_toad.lib.api.config.util.PageSeparateLine;
import com.mr_toad.lib.api.config.util.PerformanceImpact;
import com.mr_toad.lib.core.ToadLib;
import java.io.PrintWriter;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.ExtraCodecs;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ConfigPage
extends ConfigEntry<Component, ConfigPage> {
    private final PageSeparateLine separateLine;

    public ConfigPage(Component name, PageSeparateLine separateLine) {
        super("page", name, ExtraCodecs.f_252442_, ConfigEntryTypes.PAGE);
        this.separateLine = separateLine;
    }

    @Override
    public Component get() {
        String line = this.separateLine.getFormatted();
        int lineLength = line.length() / 2;
        MutableComponent lineLeft = Component.m_237113_((String)line.substring(0, lineLength));
        MutableComponent lineRight = Component.m_237113_((String)line.substring(lineLength));
        return lineLeft.m_6881_().m_130946_(this.separateLine.isRequireSpace() ? "" : " ").m_7220_((Component)this.defaultValue).m_130946_(" ").m_7220_((Component)lineRight);
    }

    @Override
    public boolean isDefault() {
        return true;
    }

    @Override
    public boolean drawInScreen() {
        return true;
    }

    @Override
    @Nullable
    public HighlightWarning getHighlightWarning() {
        return null;
    }

    @Override
    @Nullable
    public PerformanceImpact getPerformanceImpact() {
        return null;
    }

    @Override
    public Component getDescription() {
        return this.description;
    }

    @Override
    @Deprecated
    public final ConfigPage withWarning(HighlightWarning warning) {
        ToadLib.LOGGER.error(ToadLib.CONFIG, "Highlight warning cannot be added to ConfigPage!");
        return this;
    }

    @Override
    @Deprecated
    public final ConfigPage withPerformanceImpact(PerformanceImpact warning) {
        ToadLib.LOGGER.error(ToadLib.CONFIG, "Performance impact cannot be added to ConfigPage!");
        return this;
    }

    @Override
    @Deprecated
    public final ConfigPage dontDrawInScreen() {
        ToadLib.LOGGER.error(ToadLib.CONFIG, "Disabling drawInScreen makes ConfigPage useless!");
        return this;
    }

    @Override
    @Deprecated
    public final void setValue(Component value) {
    }

    @Override
    @Deprecated
    public final void resetValue() {
    }

    @Override
    @Deprecated
    public final void save(PrintWriter writer) {
    }

    @Override
    @Deprecated
    public final void load(JsonElement element) {
    }

    @Override
    @Deprecated
    public final Component getTitle() {
        throw new UnsupportedOperationException("Name is value");
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ConfigPage) {
            ConfigPage page = (ConfigPage)obj;
            return ((Component)this.value).equals(page.value) && this.separateLine == page.separateLine;
        }
        return true;
    }
}

