/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.config.entry;

import com.mojang.serialization.Codec;
import com.mr_toad.lib.api.config.entry.ConfigEntry;
import com.mr_toad.lib.api.config.entry.type.ConfigEntryTypes;
import com.mr_toad.lib.mtjava.MtJava;
import it.unimi.dsi.fastutil.SafeMath;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PercentEntry
extends ConfigEntry<Double, PercentEntry> {
    public PercentEntry(String name, double defaultValue) {
        super(name, defaultValue, Codec.DOUBLE, ConfigEntryTypes.PERCENT);
        MtJava.validatePercents(defaultValue);
    }

    @Override
    public void setValue(Double value) {
        super.setValue(value);
        MtJava.validatePercents((double)value);
    }

    public int getByPercents(int maxValue) {
        return Mth.m_14107_((double)((Double)this.get())) * maxValue;
    }

    public long getByPercents(long maxValue) {
        return Mth.m_14134_((double)((Double)this.get())) * maxValue;
    }

    public double getByPercents(double maxValue) {
        return (Double)this.get() * maxValue;
    }

    public float getByPercents(float maxValue) {
        return SafeMath.safeDoubleToFloat((double)((Double)this.get() * (double)maxValue));
    }
}

