/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.config.entry;

import com.mojang.serialization.Codec;
import com.mr_toad.lib.api.config.entry.ConfigEntry;
import com.mr_toad.lib.api.config.entry.type.ConfigEntryTypes;
import com.mr_toad.lib.api.config.error.ConfigException;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.ArrayUtils;

@OnlyIn(value=Dist.CLIENT)
public class EnumEntry<C extends Enum<C>>
extends ConfigEntry<C, EnumEntry<C>> {
    private final C[] values;
    private final Function<C, Component> naming;
    private int current;

    public EnumEntry(String name, C defaultValue, C[] values, Codec<C> codec, Function<C, Component> naming) {
        super(name, defaultValue, codec, ConfigEntryTypes.ENUM);
        this.values = values;
        this.naming = naming;
        if (!(defaultValue instanceof StringRepresentable)) {
            throw new ConfigException("'" + name + "' is not enum or not implements 'StringRepresentable' interface!");
        }
        if (values.length <= 1) {
            throw new ConfigException("Length of '" + name + "' must be greater than 1!");
        }
        this.current = ArrayUtils.indexOf((Object[])this.values, defaultValue);
    }

    @Override
    public C get() {
        return this.values[this.current];
    }

    @Override
    public void setValue(C value) {
        this.current = ArrayUtils.indexOf((Object[])this.values, value);
    }

    public C[] getValues() {
        return this.values;
    }

    public Function<C, Component> getNaming() {
        return this.naming;
    }
}

