/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.config.entry;

import com.mojang.serialization.Codec;
import com.mr_toad.lib.api.config.entry.ConfigEntry;
import com.mr_toad.lib.api.config.entry.type.ConfigEntryTypes;
import com.mr_toad.lib.mtjava.MtJava;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DegreeEntry
extends ConfigEntry<Float, DegreeEntry> {
    public DegreeEntry(String name, float defaultValue) {
        super(name, Float.valueOf(defaultValue), Codec.FLOAT, ConfigEntryTypes.DEGREE);
        MtJava.validateDegrees(defaultValue);
    }

    @Override
    public void setValue(Float value) {
        MtJava.validateDegrees(value.floatValue());
        super.setValue(value);
    }

    public float toRad() {
        return ((Float)this.get()).floatValue() * ((float)Math.PI / 180);
    }
}

