/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.config.entry;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mr_toad.lib.api.config.entry.type.ConfigEntryType;
import com.mr_toad.lib.api.config.util.DeprecationRule;
import com.mr_toad.lib.api.config.util.HighlightWarning;
import com.mr_toad.lib.api.config.util.PerformanceImpact;
import com.mr_toad.lib.core.ToadLib;
import java.io.PrintWriter;
import java.util.Objects;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public abstract class ConfigEntry<T, E extends ConfigEntry<T, E>> {
    protected Component title = CommonComponents.f_237098_;
    protected Component description = CommonComponents.f_237098_;
    @Nullable
    private HighlightWarning highlightWarning = null;
    @Nullable
    private PerformanceImpact performanceImpact = null;
    @Nullable
    private DeprecationRule deprecationRule = null;
    private boolean drawInScreen = true;
    public T value;
    protected final T defaultValue;
    protected final String name;
    private final ConfigEntryType type;
    private final Codec<T> codec;

    public ConfigEntry(String name, T defaultValue, Codec<T> codec, ConfigEntryType type) {
        this.defaultValue = defaultValue;
        this.name = name;
        this.type = type;
        this.codec = codec;
        this.value = this.defaultValue;
    }

    public E dontDrawInScreen() {
        this.drawInScreen = false;
        return (E)this;
    }

    public E addTitle(Component component) {
        this.title = component;
        return (E)this;
    }

    public E addDescription(Component component) {
        this.description = component;
        return (E)this;
    }

    public E addDeprecationRule(DeprecationRule rule) {
        this.deprecationRule = rule;
        return (E)this;
    }

    public E withWarning(HighlightWarning warning) {
        this.highlightWarning = warning;
        return (E)this;
    }

    public E withPerformanceImpact(PerformanceImpact impact) {
        this.performanceImpact = impact;
        return (E)this;
    }

    public void save(PrintWriter writer) {
        DataResult result = this.codec.encodeStart((DynamicOps)JsonOps.INSTANCE, this.get());
        result.error().ifPresent(r -> ToadLib.LOGGER.error(ToadLib.CONFIG, "Failed to save '{}':{}", (Object)this.name, (Object)r.message()));
        result.result().ifPresent(r -> {
            writer.print(this.name);
            writer.print(":");
            writer.println(r);
            ToadLib.LOGGER.info(ToadLib.CONFIG, "Saved '{}', '{}'", (Object)this, this.get());
        });
    }

    public void load(JsonElement element) {
        DataResult result = this.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)element);
        result.error().ifPresent(r -> ToadLib.LOGGER.error(ToadLib.CONFIG, "Error parsing '{}':{}", (Object)this.name, (Object)r.message()));
        result.result().ifPresent(v -> {
            this.value = v;
        });
    }

    public T get() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public void resetValue() {
        this.setValue(this.defaultValue);
    }

    public ConfigEntryType getType() {
        return this.type;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public boolean drawInScreen() {
        return this.drawInScreen;
    }

    public boolean isDefault() {
        return this.get().equals(this.getDefaultValue());
    }

    public boolean isDeprecated() {
        return this.getDeprecationRule() != null && this.getDeprecationRule().isActive();
    }

    public Component getTitle() {
        if (Objects.equals(this.title, Component.m_237119_())) {
            return Component.m_237113_((String)this.name);
        }
        return this.title;
    }

    public Component getDescription() {
        if (this.isDeprecated()) {
            return this.getDeprecationRule().getTooltip();
        }
        MutableComponent c = this.description.m_6881_();
        if (this.getHighlightWarning() != null) {
            c = CommonComponents.m_178396_((Component[])new Component[]{this.description, Component.m_237113_((String)"\n"), this.getHighlightWarning().getTooltip()});
        }
        if (this.getPerformanceImpact() != null) {
            c = CommonComponents.m_178396_((Component[])new Component[]{c, this.getPerformanceImpact().getTooltip()});
        }
        return c;
    }

    @Nullable
    public HighlightWarning getHighlightWarning() {
        return this.highlightWarning;
    }

    @Nullable
    public PerformanceImpact getPerformanceImpact() {
        return this.performanceImpact;
    }

    @Nullable
    public DeprecationRule getDeprecationRule() {
        return this.deprecationRule;
    }

    public boolean equals(Object obj) {
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ConfigEntry other = (ConfigEntry)obj;
        return Objects.equals(this.name, other.name);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

