/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.config;

import com.mr_toad.lib.api.config.ToadConfig;
import com.mr_toad.lib.api.integration.BuiltInIntegrations;
import com.mr_toad.lib.core.ToadLib;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Optional;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ToadConfigs {
    private static final Object2ObjectMap<String, ToadConfig> CONFIGS = new Object2ObjectOpenHashMap();

    public static <C extends ToadConfig> void create(String id, C config) {
        CONFIGS.put((Object)id, config);
        ToadLib.LOGGER.info(ToadLib.CONFIG, "Registered new config: '{}' for '{}'", (Object)config.path, (Object)id);
        BuiltInIntegrations.setupConfig(id, config);
        config.load();
    }

    public static Optional<ToadConfig> byId(String id) {
        return Optional.ofNullable((ToadConfig)CONFIGS.get((Object)id));
    }

    public static Component getConfigTitle(ToadConfig config) {
        if (config.title() != CommonComponents.f_237098_) {
            return config.title();
        }
        return Component.m_237113_((String)config.getConfig().toString());
    }

    public static Object2ObjectMap<String, ToadConfig> getConfigs() {
        return CONFIGS;
    }
}

