/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.config;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.mr_toad.lib.api.config.entry.ConfigEntry;
import com.mr_toad.lib.core.ToadLib;
import com.mr_toad.lib.mtjava.io.MTIO;
import com.mr_toad.lib.mtjava.strings.OptionalString;
import com.mr_toad.lib.mtjava.strings.func.StringFunction;
import com.mr_toad.lib.mtjava.strings.func.StringSupplier;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLPaths;

@OnlyIn(value=Dist.CLIENT)
public class ToadConfig {
    protected static final Splitter OPTION_SPLITTER = Splitter.on((char)':').limit(2);
    protected final List<ConfigEntry<?, ?>> entries = Lists.newArrayList();
    protected final String path;

    protected ToadConfig(StringSupplier path) {
        this.path = path.getAsString();
    }

    public void load() {
        if (Files.notExists(this.getConfig(), new LinkOption[0])) {
            this.save();
            return;
        }
        CompoundTag nbt = new CompoundTag();
        try {
            MTIO.readLines(this.getConfig()).forEach(line -> {
                Iterator iterator = OPTION_SPLITTER.split((CharSequence)line).iterator();
                nbt.m_128359_((String)iterator.next(), (String)iterator.next());
            });
        }
        catch (IOException e) {
            ToadLib.LOGGER.error(ToadLib.CONFIG, "Failed to load '{}'", (Object)this.path, (Object)e);
        }
        StringFunction<OptionalString> value = s -> nbt.m_128441_(s) ? OptionalString.of(nbt.m_128461_(s)) : OptionalString.empty();
        this.entries.forEach(configEntry -> ((OptionalString)value.apply(configEntry.toString())).ifPresent(s -> {
            JsonReader reader = new JsonReader((Reader)new StringReader(s.isEmpty() ? "\"\"" : s));
            JsonElement element = JsonParser.parseReader((JsonReader)reader);
            configEntry.load(element);
        }));
    }

    public void save() {
        try (PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.getConfig().toFile()), StandardCharsets.UTF_8));){
            this.entries.forEach(configEntry -> configEntry.save(writer));
        }
        catch (IOException e) {
            ToadLib.LOGGER.error(ToadLib.CONFIG, "Failed to save '{}'", (Object)this.path);
        }
    }

    public <T, E extends ConfigEntry<T, E>> E register(E instance) {
        this.entries.add(instance);
        return instance;
    }

    public ImmutableList<ConfigEntry<?, ?>> getEntries() {
        return ImmutableList.copyOf(this.entries);
    }

    public Component title() {
        return CommonComponents.f_237098_;
    }

    public Path getConfig() {
        return FMLPaths.CONFIGDIR.get().resolve(this.path + ".txt");
    }

    public boolean shouldCreateScreen() {
        return true;
    }
}

