/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.client.utils.graphics.gl;

import com.mr_toad.lib.api.client.utils.graphics.GraphicsException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.function.IntFunction;
import java.util.function.LongFunction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.system.MemoryUtil;

@OnlyIn(value=Dist.CLIENT)
public class ToadlyMemoryTracker {
    private static final MemoryUtil.MemoryAllocator ALLOCATOR = MemoryUtil.getAllocator((boolean)false);

    public static ByteBuffer byteAlloc(int size) {
        return ToadlyMemoryTracker.alloc(size, address -> MemoryUtil.memByteBuffer((long)address, (int)size));
    }

    public static ByteBuffer byteResize(ByteBuffer buffer, int size) {
        return ToadlyMemoryTracker.resize(buffer, size, address -> MemoryUtil.memByteBuffer((long)address, (int)size));
    }

    public static ShortBuffer shortAlloc(int size) {
        return ToadlyMemoryTracker.alloc(size, address -> MemoryUtil.memShortBuffer((long)address, (int)size));
    }

    public static ShortBuffer shortResize(ShortBuffer buffer, int size) {
        return ToadlyMemoryTracker.resize(buffer, size, address -> MemoryUtil.memShortBuffer((long)address, (int)size));
    }

    public static IntBuffer intAlloc(int size) {
        return ToadlyMemoryTracker.alloc(size, address -> MemoryUtil.memIntBuffer((long)address, (int)size));
    }

    public static IntBuffer intResize(IntBuffer buffer, int size) {
        return ToadlyMemoryTracker.resize(buffer, size, address -> MemoryUtil.memIntBuffer((long)address, (int)size));
    }

    public static FloatBuffer floatAlloc(int size) {
        return ToadlyMemoryTracker.alloc(size, address -> MemoryUtil.memFloatBuffer((long)address, (int)size));
    }

    public static FloatBuffer floatResize(FloatBuffer buffer, int size) {
        return ToadlyMemoryTracker.resize(buffer, size, address -> MemoryUtil.memFloatBuffer((long)address, (int)size));
    }

    public static LongBuffer longAlloc(int size) {
        return ToadlyMemoryTracker.alloc(size, address -> MemoryUtil.memLongBuffer((long)address, (int)size));
    }

    public static LongBuffer longResize(LongBuffer buffer, int size) {
        return ToadlyMemoryTracker.resize(buffer, size, address -> MemoryUtil.memLongBuffer((long)address, (int)size));
    }

    public static ByteBuffer byteSlice(ByteBuffer buffer, int offset, int size) {
        return ToadlyMemoryTracker.slice(offset, size, o -> MemoryUtil.memSlice((ByteBuffer)buffer, (int)size, (int)o));
    }

    public static ShortBuffer shortSlice(ShortBuffer buffer, int offset, int size) {
        return ToadlyMemoryTracker.slice(offset, size, o -> MemoryUtil.memSlice((ShortBuffer)buffer, (int)size, (int)o));
    }

    public static IntBuffer intSlice(IntBuffer buffer, int offset, int size) {
        return ToadlyMemoryTracker.slice(offset, size, o -> MemoryUtil.memSlice((IntBuffer)buffer, (int)size, (int)o));
    }

    public static FloatBuffer floatSlice(FloatBuffer buffer, int offset, int size) {
        return ToadlyMemoryTracker.slice(offset, size, o -> MemoryUtil.memSlice((FloatBuffer)buffer, (int)size, (int)o));
    }

    public static LongBuffer longSlice(LongBuffer buffer, int offset, int size) {
        return ToadlyMemoryTracker.slice(offset, size, o -> MemoryUtil.memSlice((LongBuffer)buffer, (int)size, (int)o));
    }

    public static <B extends Buffer> void memFree(B buffer) {
        long address = MemoryUtil.memAddress(buffer);
        if (address == 0L) {
            throw new GraphicsException("Failed to free memory of '" + buffer + "'", GraphicsException.In.MEMORY, new OutOfMemoryError());
        }
        ALLOCATOR.free(address);
    }

    private static <B extends Buffer> B slice(int offset, int size, IntFunction<B> slicer) {
        return (B)((Buffer)slicer.apply(size - offset));
    }

    private static <B extends Buffer> B alloc(int size, LongFunction<B> allocator) {
        long address = ALLOCATOR.malloc((long)size);
        if (address == 0L) {
            throw new GraphicsException("Failed to allocate '" + size + "' bytes for buffer", GraphicsException.In.MEMORY, new OutOfMemoryError());
        }
        return (B)((Buffer)allocator.apply(address));
    }

    private static <B extends Buffer> B resize(B buffer, int newSize, LongFunction<B> resizer) {
        long address = ALLOCATOR.realloc(MemoryUtil.memAddress0(buffer), (long)newSize);
        if (address == 0L) {
            throw new GraphicsException("Failed to re-allocate buffer from'" + buffer.capacity() + "' bytes to '" + newSize + "' bytes for buffer", GraphicsException.In.MEMORY, new OutOfMemoryError());
        }
        return (B)((Buffer)resizer.apply(address));
    }
}

