/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.client.utils.graphics;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mr_toad.lib.api.client.utils.graphics.gl.ToadlyMemoryTracker;
import com.mr_toad.lib.mtjava.MtJava;
import com.mr_toad.lib.mtjava.nio.MTNIO;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.stb.STBImage;

@OnlyIn(value=Dist.CLIENT)
public class Graphics2D {
    public static int getPixelRGB(int x, int y, ResourceLocation location) throws IOException {
        try (InputStream stream = Minecraft.m_91087_().m_91098_().m_215595_(location);){
            ByteBuffer imageBuffer = MTNIO.fromStream(stream);
            IntBuffer width = ToadlyMemoryTracker.intAlloc(1);
            IntBuffer height = ToadlyMemoryTracker.intAlloc(1);
            IntBuffer channels = ToadlyMemoryTracker.intAlloc(1);
            ByteBuffer image = STBImage.stbi_load_from_memory((ByteBuffer)imageBuffer, (IntBuffer)width, (IntBuffer)height, (IntBuffer)channels, (int)4);
            ToadlyMemoryTracker.memFree(channels);
            ToadlyMemoryTracker.memFree(imageBuffer);
            if (image == null) {
                throw new IOException("Failed to load image: " + location);
            }
            int w = width.get(0);
            int h = height.get(0);
            ToadlyMemoryTracker.memFree(width);
            ToadlyMemoryTracker.memFree(height);
            if (x < 0 || x >= w || y < 0 || y >= h) {
                STBImage.stbi_image_free((ByteBuffer)image);
                throw new IOException("Coordinates out of bounds");
            }
            int index = (x + (h - 1 - (h - 1 - y)) * w) * 4;
            int r = image.get(index) & 0xFF;
            int g = image.get(index + 1) & 0xFF;
            int b = image.get(index + 2) & 0xFF;
            STBImage.stbi_image_free((ByteBuffer)image);
            int n = r << 16 | g << 8 | b;
            return n;
        }
    }

    public static void point(GuiGraphics graphics, int centerX, int centerY, int radius) {
        Graphics2D.point(graphics, centerX, centerY, radius, MtJava.rgb2Argb(0xFFFFFF));
    }

    public static void point(GuiGraphics graphics, int centerX, int centerY, int radius, int color) {
        for (int yOffset = -radius; yOffset <= radius; ++yOffset) {
            int dx = Mth.m_14143_((float)Mth.m_14116_((float)(radius * radius - yOffset * yOffset)));
            int xStart = centerX - dx;
            int xEnd = centerX + dx;
            int yPos = centerY + yOffset;
            graphics.m_280656_(xStart, xEnd, yPos, color);
        }
    }

    public static void emptySqr(GuiGraphics graphics, int x, int y) {
        Graphics2D.emptySqr(graphics, x, y, MtJava.rgb2Argb(0));
    }

    public static void emptySqr(GuiGraphics graphics, int x, int y, int color) {
        Graphics2D.popPush(graphics.m_280168_(), stack -> {
            graphics.m_280656_(x, x + 5, y, MtJava.rgb2Argb(0x404040));
            graphics.m_280656_(x, x + 5, y + 5, MtJava.rgb2Argb(0x404040));
            graphics.m_280315_(x, y, y + 5, MtJava.rgb2Argb(0x404040));
            graphics.m_280315_(x + 5, y, y + 5, MtJava.rgb2Argb(0x404040));
            Graphics2D.fill(graphics, x + 1, y + 1, 4, 4, color);
        });
    }

    public static void fill(GuiGraphics graphics, int x, int y, int w, int h, int color) {
        graphics.m_280509_(x, y, x + w, y + h, color);
    }

    public static void fill(GuiGraphics graphics, RenderType type, int x, int y, int w, int h, int color) {
        graphics.m_285944_(type, x, y, x + w, y + h, color);
    }

    public static void fillGradient(GuiGraphics graphics, int x, int y, int w, int h, int startColor, int endColor) {
        graphics.m_280024_(x, y, x + w, y + h, startColor, endColor);
    }

    public static void fillGradient(GuiGraphics graphics, RenderType type, int x, int y, int w, int h, int startColor, int endColor) {
        graphics.m_285978_(type, x, y, x + w, y + h, startColor, endColor, 0);
    }

    public static void scissor(GuiGraphics graphics, int x, int y, int w, int h, Runnable runnable) {
        graphics.m_280588_(x, y, x + w, y + h);
        runnable.run();
        graphics.m_280618_();
    }

    public static void popPush(PoseStack stack, Consumer<PoseStack> action) {
        stack.m_85836_();
        action.accept(stack);
        stack.m_85849_();
    }
}

