/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.client.utils;

import com.google.common.collect.ImmutableList;
import com.mr_toad.lib.api.client.screen.config.ToadConfigsScreen;
import com.mr_toad.lib.api.client.screen.ex.widget.SpriteButton;
import com.mr_toad.lib.core.ToadLib;
import com.mr_toad.lib.core.mixin.access.TooltipAccessor;
import java.io.File;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ToadClientUtils {
    public static final Component SEARCH = Component.m_237115_((String)"toadlib.search");
    public static final ResourceLocation CONFIG = ToadLib.id("textures/gui/widget/toadconfig.png");
    public static final ResourceLocation ICONS = ToadLib.id("textures/gui/widget/icons.png");
    public static final ResourceLocation INFO = ToadLib.id("textures/gui/widget/info.png");
    public static final ResourceLocation RESET = ToadLib.id("textures/gui/widget/reset.png");
    public static final ResourceLocation REFRESH = ToadLib.id("textures/gui/widget/refresh.png");
    public static final ResourceLocation MAGNIFYING_GLASS = ToadLib.id("textures/gui/widget/mg_glass.png");
    public static final int RED = 0xFF0000;
    public static final int ORANGE = 0xFF8000;
    public static final int YELLOW = 0xFFFF55;
    public static final int GREEN = 0x55FF55;
    public static final int LIGHT_BLUE = -1714618369;
    public static final int BLUE = 0x5555FF;
    public static final int PURPLE = 0x9933FF;
    public static final int DEFAULT = 0x404040;
    public static final int DEFAULT_TEXT = 0xE0E0E0;
    public static final int BLACK = 0;
    public static final int WHITE = 0xFFFFFF;
    public static final int GRAY = 0xAAAAAA;
    public static final int LIGHT_GRAY = 0xA0A0A0;
    public static final int DARK_GREEN = 43520;

    public static ModelLayerLocation addMain(String modid, String name) {
        return ToadClientUtils.register(modid, name, "main");
    }

    public static ModelLayerLocation register(String modid, String name, String layer) {
        return new ModelLayerLocation(new ResourceLocation(modid, name), layer);
    }

    public static SpriteButton createInfoButton(int x, int y, Button.OnPress press) {
        SpriteButton button = SpriteButton.of(INFO, press).size(x, y, 20, 20).uv(0, 0).texSize(20, 20).setYDiff(hoveredOrFocused -> hoveredOrFocused ? 20 : 0).imageSize(64, 64).build();
        button.setShouldRenderTemp(false);
        return button;
    }

    public static SpriteButton createResetButton(int x, int y, int w, int h, Button.OnPress press) {
        return SpriteButton.of(RESET, press).size(x, y, w, h).texSize(16, 16).imageSize(16, 16).buildCentred();
    }

    public static SpriteButton createRefreshButton(int x, int y, int w, int h, Button.OnPress press) {
        return SpriteButton.of(REFRESH, press).size(x, y, w, h).texSize(16, 16).imageSize(16, 16).buildCentred();
    }

    public static <S extends Screen> SpriteButton createConfigButton(int x, int y, S parent) {
        return SpriteButton.of(CONFIG, b -> Minecraft.m_91087_().m_91152_(new ToadConfigsScreen<Screen>(parent))).size(x, y, 20, 20).imageSize(40, 40).texSize(21, 21).setYDiff(hoveredOrFocused -> hoveredOrFocused ? 21 : 0).setTooltip((Component)Component.m_237115_((String)"toadconfig.title")).buildCentred();
    }

    public static void renderMagnifyingGlass(GuiGraphics graphics, int x, int y, int w, int h) {
        graphics.m_280398_(MAGNIFYING_GLASS, x, y, 0, 0.0f, 0.0f, 20, 20, w, h);
    }

    public static boolean isMouseIn(int mx, int my, int pointX, int pointY, int radius) {
        int dx = mx - pointX;
        int dy = my - pointY;
        return dx * dx + dy * dy <= radius * radius;
    }

    public static Tooltip extendTooltip(@Nullable Tooltip tooltip, Component ... components) {
        if (tooltip == null) {
            if (components.length == 0) {
                ToadLib.LOGGER.error("Tooltip is null and length of extended elements are 0! Returned null.");
                return Tooltip.m_257550_((Component)CommonComponents.f_237098_);
            }
            return Tooltip.m_257550_((Component)CommonComponents.m_178396_((Component[])components));
        }
        if (components.length == 0) {
            return tooltip;
        }
        ImmutableList list = ImmutableList.builder().add((Object)((TooltipAccessor)tooltip).getMsg()).add((Object[])components).build();
        return Tooltip.m_257550_((Component)CommonComponents.m_178391_((Collection)list));
    }

    public static Tooltip extendTooltip(@Nullable Tooltip tooltip, Component c, boolean newLine) {
        if (tooltip == null) {
            return Tooltip.m_257550_((Component)c);
        }
        Component original = ((TooltipAccessor)tooltip).getMsg();
        if (newLine) {
            return Tooltip.m_257550_((Component)CommonComponents.m_178396_((Component[])new Component[]{original, c}));
        }
        return Tooltip.m_257550_((Component)original.m_6881_().m_7220_(c));
    }

    public static void openFile(File file) {
        Util.m_137581_().m_137648_(file.toURI());
    }

    public static int centred(int v1, int w1, int w2) {
        return v1 + w1 / 2 - w2 / 2;
    }

    public static Optional<Style> getCentredStyleOf(Font font, Component component, double mx, double my, int x, int y) {
        return ToadClientUtils.getStyleOf(font, component, mx, my, x - font.m_92852_((FormattedText)component) / 2, y);
    }

    public static Optional<Style> getStyleOf(Font font, Component component, double mx, double my, int x, int y) {
        if (mx >= (double)x && my >= (double)y && mx < (double)(x + font.m_92852_((FormattedText)component))) {
            Objects.requireNonNull(font);
            if (my < (double)(y + 9)) {
                return Optional.of(component.m_7383_());
            }
        }
        return Optional.empty();
    }
}

