/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.client.screen.interpolation;

import com.google.common.collect.ImmutableList;
import com.mr_toad.lib.api.client.init.EaseWidgetSettingsRegistry;
import com.mr_toad.lib.api.client.screen.ex.ParentableToadLibScreen;
import com.mr_toad.lib.api.client.screen.ex.widget.ExSlider;
import com.mr_toad.lib.api.client.screen.ex.widget.SpriteButton;
import com.mr_toad.lib.api.client.screen.interpolation.widget.InterpolationTypeWidget;
import com.mr_toad.lib.api.client.utils.ToadClientUtils;
import com.mr_toad.lib.mtjava.MtJava;
import com.mr_toad.lib.mtjava.collections.UniqueList;
import com.mr_toad.lib.mtjava.ints.IntPair;
import com.mr_toad.lib.mtjava.math.interpolation.HermiteInterpolation;
import com.mr_toad.lib.mtjava.math.interpolation.Interpolation;
import com.mr_toad.lib.mtjava.math.interpolation.Interpolations;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
@ParametersAreNonnullByDefault
public abstract class InterpolationSelectionScreen<P extends Screen>
extends ParentableToadLibScreen<P> {
    public static final ImmutableList<Interpolation> ALL_REGISTERED_INTERPOLATIONS = ImmutableList.copyOf(Interpolations.INTERPOLATIONS.sortByID().iterator());
    private static final Component INTERPS = Component.m_237115_((String)"toadlib.screen.interp.interpolations");
    private static final Component FROM_INFO = Component.m_237115_((String)"toadlib.screen.interp.info").m_130940_(ChatFormatting.UNDERLINE).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://easings.net")));
    private static final Component COMMON_INFO = Component.m_237115_((String)"toadlib.screen.interp.info1");
    private static final Component ADDITIONAL_INFO = Component.m_237115_((String)"toadlib.screen.interp.info2");
    protected final List<Interpolation> interpolations = new UniqueList<Interpolation>();
    protected final List<InterpolationTypeWidget> widgets = new UniqueList<InterpolationTypeWidget>();
    private float a = 1.0f;
    private float b = 1.0f;
    private float c = 1.0f;
    private float d = 1.0f;
    private float bias = 0.0f;
    private HermiteInterpolation.Tension tension = HermiteInterpolation.Tension.DEFAULT;
    protected ExSlider aSlider;
    protected ExSlider bSlider;
    protected ExSlider cSlider;
    protected ExSlider dSlider;
    protected ExSlider biasSlider;
    protected CycleButton<HermiteInterpolation.Tension> tensionCycle;
    protected SpriteButton info;
    protected Interpolation selected;

    public InterpolationSelectionScreen(List<Interpolation> interpolations, @Nullable P parent) {
        super(INTERPS, true, parent, IntPair.of(10, 10));
        this.interpolations.addAll(interpolations);
        this.selected = interpolations.get(0);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.aSlider = (ExSlider)this.m_142416_((GuiEventListener)this.createSlider("A", this.a, 0, s -> {
            this.a = (float)s.getValue();
        }));
        this.bSlider = (ExSlider)this.m_142416_((GuiEventListener)this.createSlider("B", this.b, 20, s -> {
            this.b = (float)s.getValue();
        }));
        this.cSlider = (ExSlider)this.m_142416_((GuiEventListener)this.createSlider("C", this.c, 40, s -> {
            this.c = (float)s.getValue();
        }));
        this.dSlider = (ExSlider)this.m_142416_((GuiEventListener)this.createSlider("D", this.d, 60, s -> {
            this.d = (float)s.getValue();
        }));
        this.biasSlider = (ExSlider)this.m_142416_((GuiEventListener)new ExSlider(this.f_96543_ / 2 + 60, this.f_96544_ / 2 + 25, 140, 20, (Component)Component.m_237115_((String)"toadlib.screen.hermite.bias"), CommonComponents.f_237098_, -1.0, 1.0, this.bias, 0.1, b -> {
            double v = b.getValue();
            if ((double)this.bias != v) {
                this.bias = (float)v;
            }
        }));
        this.tensionCycle = (CycleButton)this.m_142416_((GuiEventListener)CycleButton.m_168894_(HermiteInterpolation.Tension::symbol).m_168948_((Object)this.tension).m_168961_((Object[])HermiteInterpolation.Tension.values()).m_168936_(this.f_96543_ / 2 + 60, this.f_96544_ / 2 + 45, 75, 20, (Component)Component.m_237115_((String)"toadlib.screen.hermite.tension"), (b, v) -> {
            if (this.tension != v) {
                this.tension = v;
            }
        }));
        this.info = (SpriteButton)this.m_169394_((Renderable)ToadClientUtils.createInfoButton(35, 10, b -> {}));
        this.info.m_257544_(Tooltip.m_257550_((Component)CommonComponents.m_178396_((Component[])new Component[]{COMMON_INFO, ADDITIONAL_INFO})));
        Interpolation interpolation = this.selected;
        if (interpolation instanceof HermiteInterpolation) {
            HermiteInterpolation hermiteInterpolation = (HermiteInterpolation)interpolation;
            hermiteInterpolation.setBias(this.bias);
            hermiteInterpolation.setTension(this.tension);
        }
        this.fillWidgets();
        this.updateWidgetAccess();
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        graphics.m_280653_(this.f_96547_, FROM_INFO, this.f_96543_ / 2 + 60, this.f_96544_ - 10, MtJava.rgb2Argb(0x404040));
    }

    @Override
    protected boolean clickAtComponent(double mx, double my, int button) {
        return ToadClientUtils.getCentredStyleOf(this.f_96547_, FROM_INFO, mx, my, this.f_96543_ / 2 + 80, this.f_96544_ - 15).map(arg_0 -> ((InterpolationSelectionScreen)this).m_5561_(arg_0)).orElse(false);
    }

    protected void fillWidgets() {
        if (this.interpolations.isEmpty()) {
            return;
        }
        int x = 10;
        int y = 35;
        for (Interpolation value : this.interpolations) {
            if (y > 230) {
                y = 35;
                x += 20;
            }
            InterpolationTypeWidget widget = new InterpolationTypeWidget(x, y, this.selected == value, b -> {
                this.widgets.stream().filter(w -> !w.isSame(value)).forEach(w -> {
                    w.selected = false;
                });
                this.selected = value;
                this.onSelect(value);
                this.updateWidgetAccess();
            }, value);
            this.widgets.add(widget);
            this.m_142416_((GuiEventListener)widget);
            y += 20;
        }
    }

    protected void updateWidgetAccess() {
        this.aSlider.f_93623_ = false;
        this.bSlider.f_93623_ = false;
        this.cSlider.f_93623_ = false;
        this.dSlider.f_93623_ = false;
        this.biasSlider.f_93624_ = false;
        this.tensionCycle.f_93624_ = false;
        if (this.selected != null) {
            EaseWidgetSettingsRegistry.resolve(this.aSlider, this.bSlider, this.cSlider, this.dSlider, this.selected);
            if (this.selected instanceof HermiteInterpolation) {
                this.biasSlider.f_93624_ = true;
                this.tensionCycle.f_93624_ = true;
            }
        }
    }

    public abstract void onSelect(Interpolation var1);

    protected ExSlider createSlider(String s, double target, int yOffset, ExSlider.OnValueChange onApply) {
        return new ExSlider(this.f_96543_ / 2 + 75, this.f_96544_ / 2 - 60 + yOffset, 140, 20, (Component)Component.m_237113_((String)(s + ":")), CommonComponents.f_237098_, 0.0, 10.0, target, 0.1, onApply);
    }
}

