/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.client.screen.ex.widget.color;

import com.mr_toad.lib.api.client.utils.graphics.Graphics2D;
import com.mr_toad.lib.core.ToadLib;
import com.mr_toad.lib.mtjava.MtJava;
import com.mr_toad.lib.mtjava.ints.IntPair;
import java.io.IOException;
import java.util.function.IntConsumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
@ParametersAreNonnullByDefault
public class ColorPaletteWidget
extends AbstractWidget {
    private static final ResourceLocation TEXTURE = ToadLib.id("textures/gui/widget/rgb_space.png");
    protected boolean alphaAllowed = true;
    @Nullable
    private IntPair currentPos = null;
    private int value;
    private final Minecraft minecraft;
    private final IntConsumer change;
    private Palette palette;

    public ColorPaletteWidget(Minecraft minecraft, int x, int y, int value, IntConsumer change) {
        this(minecraft, x, y, value, CommonComponents.f_237098_, change);
    }

    public ColorPaletteWidget(Minecraft minecraft, int x, int y, int value, Component component, IntConsumer change) {
        super(x, y, 95, 95, component);
        this.minecraft = minecraft;
        this.change = change;
        this.value = value;
        this.palette = new Palette(this.value, this.m_252754_(), y - 10, 96, 64);
    }

    protected void m_87963_(GuiGraphics graphics, int mx, int my, float pt) {
        this.palette.render((v, x, y, w, h, hovered) -> {
            Graphics2D.fill(graphics, x - 1, y - 1, w + 2, h + 2, hovered ? MtJava.rgb2Argb(0xE0E0E0) : MtJava.rgb2Argb(0x404040));
            Graphics2D.scissor(graphics, x, y, w, h, () -> {
                graphics.m_280163_(TEXTURE, x, y, 0.0f, 0.0f, w, h, w, h);
                if (this.currentPos != null) {
                    Graphics2D.emptySqr(graphics, (Integer)this.currentPos.getFirst(), (Integer)this.currentPos.getSecond(), this.getValue());
                }
            });
        }, mx, my);
        int i = this.m_252754_() + this.m_5711_() + 5;
        int j = this.m_252907_() + 5;
        graphics.m_280509_(i - 1, j - 1, i + 16, j + 16, MtJava.rgb2Argb(0xE0E0E0));
        graphics.m_280509_(i, j, i + 15, j + 15, MtJava.rgb2Argb(this.getValue()));
        if (this.m_6035_() != CommonComponents.f_237098_) {
            graphics.m_280653_(this.minecraft.f_91062_, this.m_6035_(), this.m_252754_() + this.m_5711_() / 2, this.m_252907_(), 0xE0E0E0);
        }
    }

    public boolean m_6375_(double mx, double my, int button) {
        if (this.palette.isMouseOver(mx, my)) {
            return this.mousePaletteValue(mx, my);
        }
        return false;
    }

    public boolean m_7979_(double mx, double my, int button, double dragX, double dragY) {
        if (this.palette.isMouseOver(mx, my)) {
            return this.mousePaletteValue(mx, my);
        }
        return false;
    }

    public void m_253211_(int y) {
        super.m_253211_(y);
        this.palette = new Palette(this.value, this.m_252754_(), y, 96, 64);
        if (this.currentPos != null) {
            this.currentPos.mapSecond(cy -> cy + y);
        }
    }

    protected void m_168797_(NarrationElementOutput output) {
    }

    public void onChange() {
        this.updateValue();
        this.change.accept(this.value);
    }

    protected void updateValue() {
        int r = FastColor.ARGB32.m_13665_((int)this.palette.getValue());
        int g = FastColor.ARGB32.m_13667_((int)this.palette.getValue());
        int b = FastColor.ARGB32.m_13669_((int)this.palette.getValue());
        this.value = FastColor.ARGB32.m_13660_((int)255, (int)r, (int)g, (int)b);
    }

    protected boolean mousePaletteValue(double mx, double my) {
        int mxp = Mth.m_14107_((double)mx);
        int myp = Mth.m_14107_((double)my);
        try {
            int i = Graphics2D.getPixelRGB(mxp - this.palette.x, myp - this.palette.y, TEXTURE);
            this.palette.setValue(i);
            this.currentPos = IntPair.of(mxp, myp);
            this.onChange();
            return true;
        }
        catch (IOException e) {
            ToadLib.LOGGER.error("Error during opening palette listener!", (Throwable)e);
            return false;
        }
    }

    public int getValue() {
        return this.value;
    }

    public Palette getPalette() {
        return this.palette;
    }

    public void setAlphaAllowed(boolean alphaAllowed) {
        this.alphaAllowed = alphaAllowed;
    }

    public static class Palette {
        private int value;
        private final int x;
        private final int y;
        private final int w;
        private final int h;

        public Palette(int value, int x, int y, int w, int h) {
            this.value = value;
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }

        public void render(PaletteRenderer renderer, int mx, int my) {
            renderer.render(this.getValue(), this.x, this.y, this.w, this.h, this.isMouseOver(mx, my));
        }

        public boolean isMouseOver(double mx, double my) {
            return mx >= (double)this.x && my >= (double)this.y && mx < (double)(this.x + this.w) && my < (double)(this.y + this.h);
        }

        public void setValue(int value) {
            this.value = value;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getW() {
            return this.w;
        }

        public int getH() {
            return this.h;
        }

        public int getValue() {
            return this.value;
        }
    }

    @FunctionalInterface
    public static interface PaletteRenderer {
        public void render(int var1, int var2, int var3, int var4, int var5, boolean var6);
    }
}

