/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.client.screen.ex.widget.color;

import com.mr_toad.lib.core.ToadLib;
import com.mr_toad.lib.mtjava.MtJava;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntConsumer;
import it.unimi.dsi.fastutil.ints.IntList;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
@ParametersAreNonnullByDefault
public class ColorCellsWidget
extends AbstractWidget {
    public static final IntList DEFAULT = (IntList)Util.m_137469_((Object)new IntArrayList(), list -> {
        list.add(0xFF0000);
        list.add(0xFF8000);
        list.add(0xFFFF55);
        list.add(0x55FF55);
        list.add(-1714618369);
        list.add(0x5555FF);
        list.add(0x9933FF);
        list.add(0xA0A0A0);
        list.add(0xAAAAAA);
        list.add(0);
        list.add(0xFFFFFF);
    });
    private final IntList colorsList = new IntArrayList();
    private int titleY = this.m_252907_() - 15;
    private int selectedColor;
    private final IntList colors;
    private final IntConsumer change;
    private final int cellsPerRow;
    private final int cellSize;

    public static Builder of(IntList colors, IntConsumer change) {
        return new Builder(colors, change);
    }

    public ColorCellsWidget(int x, int y, int w, int h, int cellSize, int defaultValue, Component hoverMsg, IntList colors, IntConsumer change) {
        super(x, y, w, h, hoverMsg);
        this.colors = colors;
        this.change = change;
        this.cellSize = cellSize;
        int nextX = this.m_252754_();
        int i = 0;
        if (!colors.isEmpty()) {
            int nextY = y;
            boolean flag = true;
            for (int j = 0; j < colors.size(); ++j) {
                int color = colors.getInt(j);
                if (!this.colorsList.add(color)) {
                    ToadLib.LOGGER.error("Found duplicate entry: '{}'. Removing...", (Object)color);
                    colors.removeInt(colors.indexOf(color));
                }
                if (flag) {
                    ++i;
                }
                if ((nextX += cellSize + 5) <= w) continue;
                nextX = x;
                flag = false;
                if ((nextY += cellSize + 5) <= this.m_93694_()) continue;
                ToadLib.LOGGER.warn("Color cells list(Cell size: '{}', Cells: '{}') overflow! Re-size...", (Object)cellSize, (Object)this.size());
                this.setHeight(h + nextY * 2);
            }
        }
        this.cellsPerRow = i;
        this.selectedColor = defaultValue;
    }

    protected void m_87963_(GuiGraphics graphics, int mx, int my, float pt) {
        int nextX = this.m_252754_();
        int nextY = this.m_252907_();
        for (int i = 0; i < this.colorsList.size(); ++i) {
            int color = MtJava.rgb2Argb(this.colorsList.getInt(i));
            int borderColor = this.isSelected(color) ? FastColor.ARGB32.m_13660_((int)255, (int)167, (int)160, (int)168) : FastColor.ARGB32.m_13660_((int)255, (int)128, (int)120, (int)120);
            graphics.m_280509_(nextX, nextY, nextX + this.cellSize, nextY + this.cellSize, borderColor);
            graphics.m_280509_(nextX + 2, nextY + 2, nextX + this.cellSize - 2, nextY + this.cellSize - 2, color);
            if ((nextX += this.cellSize + 5) <= this.m_5711_()) continue;
            nextX = this.m_252754_();
            nextY += this.cellSize + 5;
        }
        if (this.m_6035_() != CommonComponents.f_237098_) {
            graphics.m_280653_(Minecraft.m_91087_().f_91062_, this.m_6035_(), this.m_252754_() * (this.getCellsPerRow() / 2), this.titleY, 0xE0E0E0);
        }
    }

    public boolean m_6375_(double mx, double my, int button) {
        if (!this.colors.isEmpty()) {
            for (int i = 0; i < this.colorsList.size(); ++i) {
                int color = this.colorsList.getInt(i);
                int nextX = this.m_252754_() + i % this.cellsPerRow * (this.cellSize + 5);
                int nextY = this.m_252907_() + i / this.cellsPerRow * (this.cellSize + 5);
                if (!(mx >= (double)nextX) || !(my >= (double)nextY) || !(mx < (double)(nextX + this.cellSize)) || !(my < (double)(nextY + this.cellSize))) continue;
                this.onChange(color);
                ToadLib.LOGGER.error("CLICKED!!");
                return true;
            }
        }
        return false;
    }

    protected void m_168797_(NarrationElementOutput output) {
    }

    public void onChange(int color) {
        this.change.accept(color);
        this.setSelected(color);
    }

    public void setSelected(int color) {
        this.selectedColor = color;
    }

    public boolean isSelected(int color) {
        return this.selectedColor == color;
    }

    public int getValue() {
        return this.selectedColor;
    }

    public int getCellsPerRow() {
        return this.cellsPerRow;
    }

    public int size() {
        return this.colorsList.size();
    }

    public static class Builder {
        private int defaultValue;
        private Component title = CommonComponents.f_237098_;
        private int x = 5;
        private int y = 5;
        private int w = 5;
        private int h = 5;
        private int cellSize = 15;
        private final IntList colors;
        private final IntConsumer change;

        public Builder(IntList colors, IntConsumer change) {
            this.colors = colors;
            this.change = change;
            this.defaultValue = colors.getInt(0);
        }

        public Builder size(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            return this;
        }

        public Builder addTitle(Component title) {
            this.title = title;
            return this;
        }

        public Builder setCellSize(int cellSize) {
            this.cellSize = cellSize;
            return this;
        }

        public Builder setDefaultValue(int defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public ColorCellsWidget build() {
            return new ColorCellsWidget(this.x, this.y, this.w, this.h, this.cellSize, this.defaultValue, this.title, this.colors, this.change);
        }
    }
}

