/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.client.screen.ex.widget;

import com.mr_toad.lib.api.client.utils.ToadClientUtils;
import com.mr_toad.lib.api.client.utils.graphics.Graphics2D;
import it.unimi.dsi.fastutil.booleans.Boolean2IntFunction;
import java.util.function.IntUnaryOperator;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
@ParametersAreNonnullByDefault
public class SpriteButton
extends Button {
    protected int u;
    protected int v;
    protected final int textureW;
    protected final int textureH;
    protected final int imageW;
    protected final int imageH;
    protected final ResourceLocation location;
    protected final Boolean2IntFunction yDiff;
    protected boolean shouldRenderTemp = true;

    public static Builder of(ResourceLocation texture, Button.OnPress press) {
        return new Builder(texture, press);
    }

    protected SpriteButton(int x, int y, int w, int h, int u, int v, Boolean2IntFunction yDiff, int textureW, int textureH, int imageW, int imageH, Button.OnPress onPress, Button.CreateNarration narration, ResourceLocation location) {
        super(x, y, w, h, CommonComponents.f_237098_, onPress, narration);
        this.imageW = imageW;
        this.imageH = imageH;
        this.u = u;
        this.v = v;
        this.yDiff = yDiff;
        this.textureW = textureW;
        this.textureH = textureH;
        this.location = location;
    }

    protected void m_87963_(GuiGraphics graphics, int mx, int my, float partialTicks) {
        if (this.isShouldRenderTemp()) {
            super.m_87963_(graphics, mx, my, partialTicks);
        }
        Graphics2D.popPush(graphics.m_280168_(), stack -> this.renderTexture(graphics, this.m_252754_(), this.m_252907_()));
    }

    public void renderTexture(GuiGraphics graphics, int x, int y) {
        graphics.m_280398_(this.location, x, y, this.u, (float)this.v, (float)((Integer)this.yDiff.apply((Object)this.m_198029_())).intValue(), this.textureW, this.textureH, this.imageW, this.imageH);
    }

    public void setShouldRenderTemp(boolean shouldRenderTemp) {
        this.shouldRenderTemp = shouldRenderTemp;
    }

    protected boolean isShouldRenderTemp() {
        return this.shouldRenderTemp;
    }

    static /* synthetic */ Button.CreateNarration access$000() {
        return f_252438_;
    }

    public static class Builder {
        private int u = 0;
        private int v = 0;
        private int x = 0;
        private int y = 0;
        private int w = 0;
        private int h = 0;
        private int textureW = 0;
        private int textureH = 0;
        private int imageW = 256;
        private int imageH = 256;
        private Boolean2IntFunction yDiff = hoveredOrFocused -> 0;
        private Button.CreateNarration narration = SpriteButton.access$000();
        private Component tooltip = CommonComponents.f_237098_;
        private final ResourceLocation location;
        private final Button.OnPress press;

        public Builder(ResourceLocation location, Button.OnPress press) {
            this.location = location;
            this.press = press;
        }

        public Builder size(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            return this;
        }

        public Builder uv(int u, int v) {
            this.u = u;
            this.v = v;
            return this;
        }

        public Builder imageSize(int w, int h) {
            this.imageW = w;
            this.imageH = h;
            return this;
        }

        public Builder texSize(int w, int h) {
            this.textureW = w;
            this.textureH = h;
            return this;
        }

        public Builder setYDiff(Boolean2IntFunction diff) {
            this.yDiff = diff;
            return this;
        }

        public Builder setTooltip(Component tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public Builder addNarration(Button.CreateNarration narration) {
            this.narration = narration;
            return this;
        }

        public SpriteButton build() {
            SpriteButton spriteButton = new SpriteButton(this.x, this.y, this.w, this.h, this.u, this.v, this.yDiff, this.textureW, this.textureH, this.imageW, this.imageH, this.press, this.narration, this.location);
            if (this.tooltip != CommonComponents.f_237098_) {
                spriteButton.m_257544_(Tooltip.m_257550_((Component)this.tooltip));
            }
            return spriteButton;
        }

        public SpriteButton buildWithMappingTexPos(final IntUnaryOperator xp, final IntUnaryOperator yp) {
            SpriteButton spriteButton = new SpriteButton(this.x, this.y, this.w, this.h, this.u, this.v, this.yDiff, this.textureW, this.textureH, this.imageW, this.imageH, this.press, this.narration, this.location){

                @Override
                public void renderTexture(GuiGraphics graphics, int x, int y) {
                    super.renderTexture(graphics, xp.applyAsInt(x), yp.applyAsInt(y));
                }
            };
            if (this.tooltip != CommonComponents.f_237098_) {
                spriteButton.m_257544_(Tooltip.m_257550_((Component)this.tooltip));
            }
            return spriteButton;
        }

        public SpriteButton buildCentred() {
            return this.buildWithMappingTexPos(xp -> ToadClientUtils.centred(xp, this.w, this.textureW), yp -> ToadClientUtils.centred(yp, this.h, this.textureH));
        }
    }
}

