/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.client.screen.config;

import com.mr_toad.lib.api.client.init.ConfigEntryWidgetsRegistry;
import com.mr_toad.lib.api.client.screen.config.widget.ConfigEntrySelectionList;
import com.mr_toad.lib.api.client.screen.config.widget.ConfigEntryWidgetMaker;
import com.mr_toad.lib.api.client.screen.ex.ParentableToadLibScreen;
import com.mr_toad.lib.api.client.screen.ex.widget.ExEditBox;
import com.mr_toad.lib.api.client.screen.ex.widget.LinkButton;
import com.mr_toad.lib.api.client.screen.ex.widget.SpriteButton;
import com.mr_toad.lib.api.client.screen.ex.widget.WidgetSelectionList;
import com.mr_toad.lib.api.client.utils.ToadClientUtils;
import com.mr_toad.lib.api.config.ToadConfig;
import com.mr_toad.lib.api.config.ToadConfigs;
import com.mr_toad.lib.api.config.entry.ConfigEntry;
import com.mr_toad.lib.api.config.entry.type.ConfigEntryType;
import com.mr_toad.lib.api.config.entry.type.ConfigEntryTypes;
import com.mr_toad.lib.mtjava.collections.execute.ExecutableArrayList;
import com.mr_toad.lib.mtjava.ints.IntPair;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ToadConfigScreen
extends ParentableToadLibScreen<Screen> {
    private static final Component RESET = Component.m_237115_((String)"toadconfig.reset");
    private final ExecutableArrayList tickable = new ExecutableArrayList();
    public final ToadConfig config;
    public ConfigEntrySelectionList configSelectionList;
    public ExEditBox searchBox;
    public SpriteButton resetButton;
    public LinkButton fileButton;
    public String lastSearch = "";

    public ToadConfigScreen(Screen parent, ToadConfig config) {
        super(CommonComponents.f_237098_, true, parent, IntPair.of(20, 7));
        this.config = config;
    }

    @Override
    protected void m_7856_() {
        this.configSelectionList = (ConfigEntrySelectionList)this.m_142416_((GuiEventListener)new ConfigEntrySelectionList(this.getMinecraft(), this.f_96543_, this.f_96544_, 30, this.f_96544_ - 20, 32));
        this.fillEntries(e -> true, true);
        MutableComponent component = Component.m_237110_((String)"toadconfig.search", (Object[])new Object[]{ToadConfigs.getConfigTitle(this.config)}).m_130940_(ChatFormatting.GRAY);
        this.searchBox = (ExEditBox)this.m_142416_((GuiEventListener)new ExEditBox(this.f_96547_, this.f_96543_ / 2 - 40, 7, 140, 20, (Component)component));
        this.searchBox.m_257771_((Component)component);
        this.searchBox.m_94151_(s -> {
            if (!Objects.equals(this.lastSearch, s)) {
                this.tickable.clear();
                this.fillEntries(e -> e.toString().contains((CharSequence)s), s.isEmpty());
                this.lastSearch = s;
            }
        });
        this.searchBox.setRenderMagnifyingGlass(true);
        this.resetButton = (SpriteButton)this.m_142416_((GuiEventListener)ToadClientUtils.createResetButton(40, 7, 20, 20, b -> {
            this.tickable.clear();
            this.config.getEntries().forEach(ConfigEntry::resetValue);
            this.resetButton.f_93623_ = !this.config.getEntries().stream().allMatch(ConfigEntry::isDefault);
        }));
        this.resetButton.m_257544_(Tooltip.m_257550_((Component)RESET));
        this.fileButton = (LinkButton)this.m_142416_((GuiEventListener)new LinkButton(65, 7, 20, 20, LinkButton.DefaultType.COMMON_FILE, this.config.getConfig()));
        this.fileButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237110_((String)"toadconfig.open_file", (Object[])new Object[]{ToadConfigs.getConfigTitle(this.config)})));
        super.m_7856_();
    }

    public void m_86600_() {
        this.tickable.run();
        this.searchBox.m_94120_();
        super.m_86600_();
    }

    @Override
    protected void onTurnBack() {
        super.onTurnBack();
        this.config.save();
    }

    public void m_7379_() {
        super.m_7379_();
        this.config.save();
    }

    public void fillEntries(Predicate<ConfigEntry<?, ?>> filter, boolean drawPages) {
        int x = 15;
        this.configSelectionList.m_93516_();
        for (int i = 0; i < this.config.getEntries().stream().filter(filter).toList().size(); ++i) {
            ConfigEntry entry = (ConfigEntry)this.config.getEntries().get(i);
            ConfigEntryType type = entry.getType();
            if (!entry.drawInScreen() || type == ConfigEntryTypes.PAGE && !drawPages) {
                return;
            }
            Optional<ConfigEntryWidgetMaker<?, ?, ?>> optional = ConfigEntryWidgetsRegistry.getMakerOf(type);
            if (!optional.isPresent()) continue;
            ConfigEntryWidgetMaker<?, ?, ?> maker = optional.get();
            Object listener = maker.make(this, x, entry);
            ConfigEntryWidgetsRegistry.getTickerOf(type).ifPresent(consumer -> this.tickable.add(() -> consumer.accept(listener)));
            if (!(listener instanceof AbstractWidget)) continue;
            AbstractWidget widget = (AbstractWidget)listener;
            widget.f_93623_ = !entry.isDeprecated();
            this.configSelectionList.addEntry(new WidgetSelectionList.Entry(widget));
        }
    }
}

