/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.client.init;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.mr_toad.lib.api.helper.registry.common.ValueHolder;
import com.mr_toad.lib.core.ToadLib;
import com.mr_toad.lib.mtjava.math.interpolation.Interpolation;
import com.mr_toad.lib.mtjava.math.interpolation.Interpolations;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.widget.ForgeSlider;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
public class EaseWidgetSettingsRegistry {
    public static final Map<Interpolation, EnumSet<Arg>> EASE_REGISTRY = Maps.newHashMap();

    @ApiStatus.Internal
    public static void init() {
        EaseWidgetSettingsRegistry.registerEase((Set<ValueHolder<Interpolation>>)ImmutableSet.of(Interpolations.BACK_IN, Interpolations.BACK_OUT, Interpolations.BACK_INOUT, Interpolations.ELASTIC_IN, Interpolations.ELASTIC_OUT, Interpolations.ELASTIC_INOUT, (Object[])new ValueHolder[0]), EnumSet.of(Arg.A));
        EaseWidgetSettingsRegistry.registerEase((Set<ValueHolder<Interpolation>>)ImmutableSet.of(Interpolations.BOUNCE_IN, Interpolations.BOUNCE_OUT, Interpolations.BOUNCE_INOUT), EnumSet.of(Arg.A, Arg.B));
        EaseWidgetSettingsRegistry.registerEase(Interpolations.CUBIC, EnumSet.of(Arg.A, Arg.B));
    }

    public static void registerEase(Set<ValueHolder<Interpolation>> interpolations, EnumSet<Arg> args) {
        interpolations.forEach(interpolation -> EaseWidgetSettingsRegistry.registerEase(interpolation, args));
    }

    public static void registerEase(ValueHolder<Interpolation> interpolation, EnumSet<Arg> args) {
        Interpolation i = interpolation.get();
        if (EASE_REGISTRY.containsKey(i)) {
            ToadLib.LOGGER.error("Widget ease settings is already registered for '{}'", (Object)i.name());
        } else {
            EASE_REGISTRY.put(i, args);
        }
    }

    @ApiStatus.Internal
    public static void resolve(ForgeSlider a, ForgeSlider b, ForgeSlider c, ForgeSlider d, Interpolation interpolation) {
        EnumSet<Arg> args = EASE_REGISTRY.get(interpolation);
        if (args == null || args.isEmpty()) {
            return;
        }
        a.f_93623_ = args.contains((Object)Arg.A);
        b.f_93623_ = args.contains((Object)Arg.B);
        c.f_93623_ = args.contains((Object)Arg.C);
        d.f_93623_ = args.contains((Object)Arg.D);
    }

    public static enum Arg {
        A,
        B,
        C,
        D;

    }
}

