/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.client.init;

import com.mr_toad.lib.api.client.screen.config.widget.ConfigEntryWidgetMaker;
import com.mr_toad.lib.api.client.screen.config.widget.ConfigPageWidget;
import com.mr_toad.lib.api.client.screen.config.widget.UnexpectedEntry;
import com.mr_toad.lib.api.client.screen.ex.widget.ExCheckbox;
import com.mr_toad.lib.api.client.screen.ex.widget.ExEditBox;
import com.mr_toad.lib.api.client.screen.ex.widget.ExSlider;
import com.mr_toad.lib.api.client.screen.ex.widget.color.ColorCellsWidget;
import com.mr_toad.lib.api.client.screen.ex.widget.color.ColorPaletteWidget;
import com.mr_toad.lib.api.config.entry.ColorEntry;
import com.mr_toad.lib.api.config.entry.ConfigEntry;
import com.mr_toad.lib.api.config.entry.EnumEntry;
import com.mr_toad.lib.api.config.entry.primitive.NumericEntry;
import com.mr_toad.lib.api.config.entry.primitive.StringEntry;
import com.mr_toad.lib.api.config.entry.type.ConfigEntryType;
import com.mr_toad.lib.api.config.entry.type.ConfigEntryTypes;
import com.mr_toad.lib.api.config.error.ConfigException;
import com.mr_toad.lib.core.ToadLib;
import com.mr_toad.lib.mtjava.math.MtMath;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.math.BigDecimal;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
public class ConfigEntryWidgetsRegistry {
    private static final Object2ObjectMap<ConfigEntryType, ConfigEntryWidgetMaker<?, ?, ?>> MAKERS = new Object2ObjectOpenHashMap();
    private static final Object2ObjectMap<ConfigEntryType, Consumer<GuiEventListener>> TICKERS = new Object2ObjectOpenHashMap();

    @ApiStatus.Internal
    public static void init() {
        ConfigEntryWidgetsRegistry.initMakers();
        ConfigEntryWidgetsRegistry.initTickers();
    }

    private static void initMakers() {
        ConfigEntryWidgetsRegistry.registerMaker(ConfigEntryTypes.BOOL, Boolean.TYPE, (owner, nextX, entry) -> {
            ExCheckbox checkbox = new ExCheckbox(nextX, 0, entry.getTitle(), (Boolean)entry.get(), b -> {
                if ((Boolean)entry.get() != b) {
                    entry.setValue(b);
                }
            });
            checkbox.m_257544_(Tooltip.m_257550_((Component)entry.getDescription()));
            return checkbox;
        });
        ConfigEntryWidgetsRegistry.registerMaker(ConfigEntryTypes.STRING, String.class, (owner, nextX, entry) -> {
            AtomicReference<String> lastContent = new AtomicReference<String>("");
            ExEditBox editBox = new ExEditBox(Minecraft.m_91087_().f_91062_, nextX, 0, 220, 20, entry.getTitle());
            editBox.m_257544_(Tooltip.m_257550_((Component)entry.getDescription()));
            editBox.m_94151_(s -> {
                if (!((String)lastContent.get()).equals(s)) {
                    if (!((String)entry.get()).equals(s)) {
                        entry.setValue(s);
                    }
                    lastContent.set((String)s);
                }
            });
            editBox.m_94144_((String)entry.get());
            if (entry instanceof StringEntry) {
                StringEntry stringEntry = (StringEntry)entry;
                editBox.m_94153_(stringEntry.getFilter());
                editBox.m_94149_(stringEntry.getFormatter());
                editBox.m_94199_(stringEntry.getMaxLength());
            } else {
                ToadLib.LOGGER.error(ToadLib.CONFIG, "Failed to apply custom settings of string value: '{}'", (Object)entry);
            }
            return editBox;
        });
        ConfigEntryWidgetsRegistry.registerMaker(ConfigEntryTypes.ENUM, Enum.class, (owner, nextX, entry) -> {
            if (entry instanceof EnumEntry) {
                EnumEntry enumEntry = (EnumEntry)entry;
                return CycleButton.m_168894_(enumEntry.getNaming()).m_168961_((Object[])enumEntry.getValues()).m_168948_(enumEntry.get()).m_232498_(o -> Tooltip.m_257550_((Component)entry.getDescription())).m_168936_(nextX, 0, 220, 20, entry.getTitle(), (b, v) -> {
                    if (!((Enum)enumEntry.get()).equals(v)) {
                        enumEntry.setValue((Enum)v);
                    }
                });
            }
            ToadLib.LOGGER.error(ToadLib.CONFIG, "'{}' is not enum!", (Object)entry);
            return new UnexpectedEntry(nextX, 0);
        });
        ConfigEntryWidgetsRegistry.registerMaker(ConfigEntryTypes.BYTE, Byte.TYPE, (owner, nextX, entry) -> {
            try {
                if (entry instanceof NumericEntry) {
                    NumericEntry numericEntry = (NumericEntry)entry;
                    ExSlider slider = new ExSlider(nextX, 0, 220, 19, entry.getTitle(), CommonComponents.f_237098_, ((Number)numericEntry.getMin()).byteValue(), ((Number)numericEntry.getMax()).byteValue(), ((Byte)entry.get()).byteValue(), numericEntry.getStep(), num -> numericEntry.setValue(MtMath.bfloor(num.getValue())));
                    slider.m_257544_(Tooltip.m_257550_((Component)entry.getDescription()));
                    return slider;
                }
                throw new ConfigException("'" + entry + "' is not byte!");
            }
            catch (ConfigException | ClassCastException | IllegalArgumentException e) {
                ToadLib.LOGGER.error(ToadLib.CONFIG, "Error making '{}'", (Object)entry, (Object)e);
                return new UnexpectedEntry(nextX, 0);
            }
        });
        ConfigEntryWidgetsRegistry.registerMaker(ConfigEntryTypes.SHORT, Short.TYPE, (owner, nextX, entry) -> {
            try {
                if (entry instanceof NumericEntry) {
                    NumericEntry numericEntry = (NumericEntry)entry;
                    ExSlider slider = new ExSlider(nextX, 0, 220, 19, entry.getTitle(), CommonComponents.f_237098_, ((Number)numericEntry.getMin()).shortValue(), ((Number)numericEntry.getMax()).shortValue(), ((Short)entry.get()).shortValue(), numericEntry.getStep(), num -> numericEntry.setValue(MtMath.sfloor(num.getValue())));
                    slider.m_257544_(Tooltip.m_257550_((Component)entry.getDescription()));
                    return slider;
                }
                throw new ConfigException("'" + entry + "' is not short!");
            }
            catch (ConfigException | ClassCastException | IllegalArgumentException e) {
                ToadLib.LOGGER.error(ToadLib.CONFIG, "Error making '{}'", (Object)entry, (Object)e);
                return new UnexpectedEntry(nextX, 0);
            }
        });
        ConfigEntryWidgetsRegistry.registerMaker(ConfigEntryTypes.INT, Integer.TYPE, (owner, nextX, entry) -> {
            try {
                if (entry instanceof NumericEntry) {
                    NumericEntry numericEntry = (NumericEntry)entry;
                    ExSlider slider = new ExSlider(nextX, 0, 220, 19, entry.getTitle(), CommonComponents.f_237098_, ((Number)numericEntry.getMin()).intValue(), ((Number)numericEntry.getMax()).intValue(), ((Integer)entry.get()).intValue(), numericEntry.getStep(), num -> numericEntry.setValue(Mth.m_14107_((double)num.getValue())));
                    slider.m_257544_(Tooltip.m_257550_((Component)entry.getDescription()));
                    return slider;
                }
                throw new ConfigException("'" + entry + "' is not int!");
            }
            catch (ConfigException | ClassCastException | IllegalArgumentException e) {
                ToadLib.LOGGER.error(ToadLib.CONFIG, "Error making '{}'", (Object)entry, (Object)e);
                return new UnexpectedEntry(nextX, 0);
            }
        });
        ConfigEntryWidgetsRegistry.registerMaker(ConfigEntryTypes.LONG, Long.TYPE, (owner, nextX, entry) -> {
            try {
                if (entry instanceof NumericEntry) {
                    NumericEntry numericEntry = (NumericEntry)entry;
                    ExSlider slider = new ExSlider(nextX, 0, 220, 19, entry.getTitle(), CommonComponents.f_237098_, ((Number)numericEntry.getMin()).longValue(), ((Number)numericEntry.getMax()).longValue(), ((Long)entry.get()).longValue(), numericEntry.getStep(), num -> numericEntry.setValue(Mth.m_14134_((double)num.getValue())));
                    slider.m_257544_(Tooltip.m_257550_((Component)entry.getDescription()));
                    return slider;
                }
                throw new ConfigException("'" + entry + "' is not long!");
            }
            catch (ConfigException | ClassCastException | IllegalArgumentException e) {
                ToadLib.LOGGER.error(ToadLib.CONFIG, "Error making '{}'", (Object)entry, (Object)e);
                return new UnexpectedEntry(nextX, 0);
            }
        });
        ConfigEntryWidgetsRegistry.registerMaker(ConfigEntryTypes.LONG, Long.TYPE, (owner, nextX, entry) -> {
            try {
                if (entry instanceof NumericEntry) {
                    NumericEntry numericEntry = (NumericEntry)entry;
                    ExSlider slider = new ExSlider(nextX, 0, 220, 19, entry.getTitle(), CommonComponents.f_237098_, ((Number)numericEntry.getMin()).longValue(), ((Number)numericEntry.getMax()).longValue(), ((Long)entry.get()).longValue(), numericEntry.getStep(), num -> numericEntry.setValue(Mth.m_14134_((double)num.getValue())));
                    slider.m_257544_(Tooltip.m_257550_((Component)entry.getDescription()));
                    return slider;
                }
                throw new ConfigException("'" + entry + "' is not long!");
            }
            catch (ConfigException | ClassCastException | IllegalArgumentException e) {
                ToadLib.LOGGER.error(ToadLib.CONFIG, "Error making '{}'", (Object)entry, (Object)e);
                return new UnexpectedEntry(nextX, 0);
            }
        });
        ConfigEntryWidgetsRegistry.registerMaker(ConfigEntryTypes.BIG_DECIMAL, BigDecimal.class, (owner, nextX, entry) -> {
            try {
                if (entry instanceof NumericEntry) {
                    NumericEntry numericEntry = (NumericEntry)entry;
                    ExSlider slider = new ExSlider(nextX, 0, 220, 19, entry.getTitle(), CommonComponents.f_237098_, ((Number)numericEntry.getMin()).doubleValue(), ((Number)numericEntry.getMax()).doubleValue(), ((BigDecimal)entry.get()).doubleValue(), numericEntry.getStep(), num -> numericEntry.setValue(BigDecimal.valueOf(num.getValue())));
                    slider.m_257544_(Tooltip.m_257550_((Component)entry.getDescription()));
                    return slider;
                }
                throw new ConfigException("'" + entry + "' is not float/double!");
            }
            catch (ConfigException | ClassCastException | IllegalArgumentException e) {
                ToadLib.LOGGER.error(ToadLib.CONFIG, "Error making '{}'", (Object)entry, (Object)e);
                return new UnexpectedEntry(nextX, 0);
            }
        });
        ConfigEntryWidgetsRegistry.registerMaker(ConfigEntryTypes.DEGREE, Float.TYPE, (owner, nextX, entry) -> {
            ExSlider slider = new ExSlider(nextX, 0, 220, 19, entry.getTitle(), (Component)Component.m_237113_((String)"\u00b0"), -180.0, 180.0, ((Float)entry.get()).floatValue(), 1.0, num -> entry.setValue(Float.valueOf((float)num.getValue())));
            slider.m_257544_(Tooltip.m_257550_((Component)entry.getDescription()));
            return slider;
        });
        ConfigEntryWidgetsRegistry.registerMaker(ConfigEntryTypes.PERCENT, Double.TYPE, (owner, nextX, entry) -> {
            ExSlider slider = new ExSlider(nextX, 0, 220, 19, entry.getTitle(), (Component)Component.m_237113_((String)"%"), 0.0, 1.0, (Double)entry.get(), 0.01, num -> entry.setValue(num.getValue()));
            slider.m_257544_(Tooltip.m_257550_((Component)entry.getDescription()));
            return slider;
        });
        ConfigEntryWidgetsRegistry.registerMaker(ConfigEntryTypes.COLOR, Integer.TYPE, (owner, nextX, entry) -> {
            try {
                if (entry instanceof ColorEntry) {
                    ColorEntry colorEntry = (ColorEntry)entry;
                    ColorEntry.Mode mode = colorEntry.getMode();
                    return switch (mode) {
                        default -> throw new IncompatibleClassChangeError();
                        case ColorEntry.Mode.PALETTE -> {
                            ColorPaletteWidget widget = new ColorPaletteWidget(owner.getMinecraft(), nextX, 5, colorEntry.get(), entry.getTitle(), colorEntry::setValue);
                            widget.m_257544_(Tooltip.m_257550_((Component)entry.getDescription()));
                            widget.setAlphaAllowed(colorEntry.isAllowAlpha());
                            yield widget;
                        }
                        case ColorEntry.Mode.CELLS -> {
                            if (colorEntry.getCells().isEmpty()) {
                                throw new ConfigException("Cells color config entry is empty!");
                            }
                            int cellSize = colorEntry.getCellSize();
                            if (cellSize == 0) {
                                ToadLib.LOGGER.warn(ToadLib.CONFIG, "Cells of '{}' is invisible!", (Object)entry);
                            }
                            ColorCellsWidget widget = ColorCellsWidget.of(colorEntry.getCells(), colorEntry::setValue).addTitle(entry.getTitle()).size(nextX, 0, 90, 90).setCellSize(cellSize).build();
                            widget.m_257544_(Tooltip.m_257550_((Component)entry.getDescription()));
                            yield widget;
                        }
                    };
                }
                throw new ConfigException("'" + entry + "' isn't color!");
            }
            catch (ConfigException | ClassCastException | IllegalArgumentException e) {
                ToadLib.LOGGER.error(ToadLib.CONFIG, "Error making '{}'", (Object)entry, (Object)e);
                return new UnexpectedEntry(nextX, 0);
            }
        });
        ConfigEntryWidgetsRegistry.registerMaker(ConfigEntryTypes.PAGE, Component.class, (owner, nextX, entry) -> new ConfigPageWidget(owner.configSelectionList.getWidth() / 2, 0, (Component)entry.get()));
    }

    private static void initTickers() {
        ConfigEntryWidgetsRegistry.registerTicker(ConfigEntryTypes.STRING, w -> {
            if (w instanceof EditBox) {
                EditBox editBox = (EditBox)w;
                editBox.m_94120_();
            }
        });
    }

    public static <T, E extends ConfigEntry<T, E>, W extends GuiEventListener & Renderable> void registerMaker(ConfigEntryType type, Class<T> of, ConfigEntryWidgetMaker<T, E, W> maker) {
        MAKERS.put((Object)type, maker);
        ToadLib.LOGGER.info(ToadLib.CONFIG, "Registered maker for '{}' of class '{}'", (Object)type, of);
    }

    public static void registerTicker(ConfigEntryType type, Consumer<GuiEventListener> ticker) {
        TICKERS.put((Object)type, ticker);
        ToadLib.LOGGER.info(ToadLib.CONFIG, "Registered ticker for '{}'", (Object)type);
    }

    public static Optional<ConfigEntryWidgetMaker<?, ?, ?>> getMakerOf(ConfigEntryType entryType) {
        return Optional.ofNullable((ConfigEntryWidgetMaker)MAKERS.get((Object)entryType));
    }

    public static Optional<Consumer<GuiEventListener>> getTickerOf(ConfigEntryType entryType) {
        return Optional.ofNullable((Consumer)TICKERS.get((Object)entryType));
    }
}

