/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.entity.custom.obsidilith;

import com.cerbon.bosses_of_mass_destruction.entity.ai.action.IActionWithCooldown;
import com.cerbon.bosses_of_mass_destruction.particle.BMDParticles;
import com.cerbon.bosses_of_mass_destruction.sound.BMDSounds;
import com.cerbon.bosses_of_mass_destruction.util.BMDUtils;
import com.cerbon.cerbons_api.api.general.event.Event;
import com.cerbon.cerbons_api.api.general.event.EventScheduler;
import com.cerbon.cerbons_api.api.general.event.IEvent;
import com.cerbon.cerbons_api.api.general.event.TimedEvent;
import com.cerbon.cerbons_api.api.static_utilities.CapabilityUtils;
import com.cerbon.cerbons_api.api.static_utilities.MathUtils;
import com.cerbon.cerbons_api.api.static_utilities.ParticleUtils;
import com.cerbon.cerbons_api.api.static_utilities.SoundUtils;
import com.cerbon.cerbons_api.api.static_utilities.VecUtils;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class AnvilAction
implements IActionWithCooldown {
    private final Mob actor;
    private final float explosionPower;
    private final EventScheduler eventScheduler;
    private final List<Vec3> circlePoints;

    public AnvilAction(Mob actor, float explosionPower) {
        this.actor = actor;
        this.explosionPower = explosionPower;
        this.eventScheduler = CapabilityUtils.getLevelEventScheduler((Level)actor.m_9236_());
        this.circlePoints = MathUtils.buildBlockCircle((double)2.0);
    }

    @Override
    public int perform() {
        LivingEntity target = this.actor.m_5448_();
        Level level = this.actor.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return 80;
        }
        this.performAttack(target, (ServerLevel)level);
        return 80;
    }

    private void performAttack(LivingEntity target, ServerLevel level) {
        SoundUtils.playSound((ServerLevel)level, (Vec3)this.actor.m_20182_(), (SoundEvent)((SoundEvent)BMDSounds.OBSIDILITH_PREPARE_ATTACK.get()), (SoundSource)SoundSource.HOSTILE, (float)3.0f, (float)1.0f, (double)64.0, null);
        this.eventScheduler.addEvent((IEvent)new TimedEvent(() -> {
            Vec3 targetPos = target.m_20182_();
            Vec3 teleportPos = targetPos.m_82549_(VecUtils.yAxis.m_82490_(24.0));
            Vec3 originalPos = this.actor.m_20182_();
            this.actor.m_7678_(teleportPos.f_82479_, teleportPos.f_82480_, teleportPos.f_82481_, this.actor.m_146908_(), this.actor.m_146909_());
            SoundUtils.playSound((ServerLevel)level, (Vec3)teleportPos, (SoundEvent)((SoundEvent)BMDSounds.OBSIDILITH_TELEPORT.get()), (SoundSource)SoundSource.HOSTILE, (float)3.0f, (double)64.0, null);
            for (Vec3 pos : this.circlePoints) {
                BlockPos particlePos = BMDUtils.findGroundBelow(this.actor.m_9236_(), BlockPos.m_274446_((Position)pos.m_82549_(targetPos)).m_6630_(3), pos1 -> true).m_7494_();
                if (particlePos.m_123342_() == 0) continue;
                ParticleUtils.spawnParticle((ServerLevel)level, (ParticleOptions)((ParticleOptions)BMDParticles.OBSIDILITH_ANVIL_INDICATOR.get()), (Vec3)VecUtils.asVec3((BlockPos)particlePos).m_82549_(new Vec3(0.5, 0.1, 0.5)), (Vec3)Vec3.f_82478_, (int)0, (double)0.0);
            }
            this.eventScheduler.addEvent((IEvent)new TimedEvent(() -> {
                Supplier<Boolean> shouldLand = () -> this.actor.m_20096_() || this.actor.m_20186_() < 0.0;
                Supplier<Boolean> shouldCancelLand = () -> !this.actor.m_6084_() || (Boolean)shouldLand.get() != false;
                this.eventScheduler.addEvent((IEvent)new Event(shouldLand, () -> {
                    this.actor.m_9236_().m_254849_((Entity)this.actor, this.actor.m_20185_(), this.actor.m_20186_(), this.actor.m_20189_(), this.explosionPower, Level.ExplosionInteraction.MOB);
                    this.eventScheduler.addEvent((IEvent)new TimedEvent(() -> {
                        this.actor.m_7678_(originalPos.f_82479_, originalPos.f_82480_, originalPos.f_82481_, this.actor.m_146908_(), this.actor.m_146909_());
                        SoundUtils.playSound((ServerLevel)level, (Vec3)this.actor.m_20182_(), (SoundEvent)((SoundEvent)BMDSounds.OBSIDILITH_TELEPORT.get()), (SoundSource)SoundSource.HOSTILE, (float)1.0f, (double)64.0, null);
                    }, 20, 1, () -> !this.actor.m_6084_()));
                }, shouldCancelLand));
            }, 1, 1, () -> !this.actor.m_6084_()));
        }, 20, 1, () -> !this.actor.m_6084_()));
    }
}

