/*
 * Decompiled with CFR 0.152.
 */
package net.exmo.cataclysm_modifier;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;

public class Main {
    public static void main(String[] args) {
        System.out.println("Hello world!");
        Main.processJsonFiles("G:\\exmo\\CataclysmModifier\\run\\config\\exmo\\modifier");
    }

    public static void processJsonFiles(String dirPath) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        File directory = new File(dirPath);
        File combinedFile = new File(directory, "combined_loc.json");
        JsonObject combinedRoot = new JsonObject();
        File[] files = directory.listFiles((dir, name) -> name.endsWith(".json"));
        if (files == null) {
            return;
        }
        for (File file : files) {
            try (FileReader reader = new FileReader(file);){
                JsonObject root = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                JsonObject newRoot = new JsonObject();
                for (Map.Entry entry : root.entrySet()) {
                    if (!((JsonElement)entry.getValue()).isJsonObject()) continue;
                    JsonObject valueObj = ((JsonElement)entry.getValue()).getAsJsonObject().deepCopy();
                    if (valueObj.has("localDescription")) {
                        String newKey = (String)entry.getKey() + "_loc";
                        String description = valueObj.get("localDescription").getAsString();
                        valueObj.addProperty("localDescription", newKey);
                        combinedRoot.addProperty(newKey, description);
                    }
                    newRoot.add((String)entry.getKey(), (JsonElement)valueObj);
                }
                try (FileWriter writer = new FileWriter(file);){
                    gson.toJson((JsonElement)newRoot, (Appendable)writer);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try (FileWriter combinedWriter = new FileWriter(combinedFile);){
            gson.toJson((JsonElement)combinedRoot, (Appendable)combinedWriter);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

