/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced.world.structure;

import com.barion.dungeons_enhanced.DEUtil;
import com.barion.dungeons_enhanced.registry.DEStructures;
import com.barion.dungeons_enhanced.world.gen.DETerrainAnalyzer;
import com.barion.dungeons_enhanced.world.structure.prefabs.DEGroundStructure;
import com.barion.dungeons_enhanced.world.structure.prefabs.utils.DEStructureTemplates;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;

public final class DETallWitchHut
extends DEGroundStructure {
    public static final String ID = "tall_witch_hut";
    public static final Codec<DETallWitchHut> CODEC = DETallWitchHut.m_226607_(DETallWitchHut::new);

    public DETallWitchHut(Structure.StructureSettings settings) {
        super(settings, DEUtil.pieceBuilder().yOffset(-3).add(ID).build(), () -> DEStructures.TALL_WITCH_HUT.getType());
    }

    @Override
    @Nonnull
    public Optional<Structure.GenerationStub> m_214086_(@Nonnull Structure.GenerationContext context) {
        DEStructureTemplates.Template piece = this._templates.getRandom((RandomSource)context.f_226626_());
        BlockPos rawPos = this.getGenPos(context.f_226628_()).m_6630_(piece.yOffset);
        Rotation rotation = Rotation.m_221990_((RandomSource)context.f_226626_());
        context.f_226629_().m_141928_();
        Vec3i size = context.f_226625_().m_230359_(piece.Resource).m_163808_(rotation);
        Pair<Float, Boolean> result = DETerrainAnalyzer.isFlatEnough(rawPos, size, 1, 4, Heightmap.Types.WORLD_SURFACE_WG, context.f_226622_(), context.f_226629_(), context.f_226624_());
        if (!((Boolean)result.getSecond()).booleanValue()) {
            return Optional.empty();
        }
        BlockPos pos = rawPos.m_175288_(Math.round(((Float)result.getFirst()).floatValue())).m_6630_(piece.yOffset);
        int oceanFloor = context.f_226622_().m_214096_(pos.m_123341_(), pos.m_123343_(), Heightmap.Types.OCEAN_FLOOR_WG, context.f_226629_(), context.f_226624_());
        int dif = pos.m_123342_() - oceanFloor;
        if (dif > 4) {
            return Optional.empty();
        }
        return DETallWitchHut.at(pos, builder -> DETallWitchHut.generatePieces(builder, pos, piece, rotation, context, x$0 -> DEGroundStructure.assemble(x$0)));
    }
}

