/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced;

import com.barion.dungeons_enhanced.data.DETags;
import com.barion.dungeons_enhanced.registry.DEStructures;
import com.legacy.structure_gel.api.config.StructureConfig;
import com.legacy.structure_gel.api.registry.registrar.Registrar;
import com.legacy.structure_gel.api.registry.registrar.StructureRegistrar;
import java.security.InvalidParameterException;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.Tags;
import org.apache.commons.lang3.tuple.Pair;

public final class DEConfig {
    public static final Common COMMON;
    protected static final ForgeConfigSpec COMMON_SPEC;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        protected Common(ForgeConfigSpec.Builder builder) {
            Common.structureBiomes(DEStructures.CASTLE).whitelist(new TagKey[]{Tags.Biomes.IS_COLD_OVERWORLD, Tags.Biomes.IS_SNOWY}).blacklist(new TagKey[]{Tags.Biomes.IS_WATER, Tags.Biomes.IS_MOUNTAIN, DETags.Biomes.IS_SHORE}).popBiomes().build(builder);
            Common.overworldExceptStructure(builder, DEStructures.DEEP_CRYPT, new TagKey[0]);
            Common.tagsStructure(builder, DEStructures.DESERT_TEMPLE, BiomeTags.f_207614_);
            Common.tagsStructure(builder, DEStructures.DESERT_TOMB, BiomeTags.f_207614_);
            Common.tagsStructure(builder, DEStructures.DRUID_CIRCLE, Tags.Biomes.IS_PLAINS);
            Common.overworldExceptStructure(builder, DEStructures.DUNGEON_VARIANT, new TagKey[0]);
            Common.tagsStructure(builder, DEStructures.ELDERS_TEMPLE, BiomeTags.f_207602_);
            Common.shipStructure(builder, DEStructures.FISHING_SHIP);
            Common.tagsStructure(builder, DEStructures.FLYING_DUTCHMAN, Tags.Biomes.IS_WATER);
            Common.structureBiomes(DEStructures.HAY_STORAGE).whitelist(new TagKey[]{BiomeTags.f_215816_}).blacklist(new TagKey[]{DETags.Biomes.IS_BAD_FOR_STRUCTURE}).popBiomes().build(builder);
            Common.structureBiomes(DEStructures.ICE_PIT).whitelist(new TagKey[]{Tags.Biomes.IS_SNOWY}).blacklist(new TagKey[]{Tags.Biomes.IS_WATER, Tags.Biomes.IS_MOUNTAIN, DETags.Biomes.IS_SHORE}).popBiomes().build(builder);
            Common.tagsStructure(builder, DEStructures.JUNGLE_MONUMENT, BiomeTags.f_207616_);
            Common.structureBiomes(DEStructures.LARGE_DUNGEON).whitelist(new TagKey[]{Tags.Biomes.IS_PLAINS, BiomeTags.f_207611_, BiomeTags.f_207609_}).blacklist(new TagKey[]{DETags.Biomes.IS_BAD_FOR_STRUCTURE, Tags.Biomes.IS_MOUNTAIN, Tags.Biomes.IS_WATER}).popBiomes().build(builder);
            Common.tagsStructure(builder, DEStructures.MINERS_HOUSE, BiomeTags.f_207607_);
            Common.biomesStructure(builder, DEStructures.MONSTER_MAZE, Biomes.f_48151_);
            Common.biomesStructure(builder, DEStructures.MUSHROOM_HOUSE, Biomes.f_48215_);
            Common.tagsStructure(builder, DEStructures.PILLAGER_CAMP, BiomeTags.f_207622_);
            Common.shipStructure(builder, DEStructures.PIRATE_SHIP);
            Common.structureBiomes(DEStructures.RUINED_BUILDING).whitelist(new TagKey[]{Tags.Biomes.IS_PLAINS, BiomeTags.f_207611_, BiomeTags.f_207609_}).blacklist(new TagKey[]{DETags.Biomes.IS_BAD_FOR_STRUCTURE, Tags.Biomes.IS_MOUNTAIN, Tags.Biomes.IS_WATER}).popBiomes().build(builder);
            Common.structureBiomes(DEStructures.STABLES).whitelist(new TagKey[]{Tags.Biomes.IS_PLAINS, BiomeTags.f_207611_}).blacklist(new TagKey[]{DETags.Biomes.IS_BAD_FOR_STRUCTURE, Tags.Biomes.IS_MOUNTAIN, Tags.Biomes.IS_WATER}).blacklist(new ResourceKey[]{Biomes.f_48151_}).popBiomes().build(builder);
            Common.tagsStructure(builder, DEStructures.SUNKEN_SHRINE, BiomeTags.f_207603_);
            Common.tagsStructure(builder, DEStructures.TALL_WITCH_HUT, BiomeTags.f_207589_);
            Common.overworldExceptStructure(builder, DEStructures.TOWER_OF_THE_UNDEAD, Tags.Biomes.IS_SANDY, Tags.Biomes.IS_WATER, BiomeTags.f_207610_, DETags.Biomes.IS_BAD_FOR_STRUCTURE, BiomeTags.f_207607_);
            Common.tagsStructure(builder, DEStructures.TREE_HOUSE, BiomeTags.f_207610_);
            Common.tagsNoWaterStructure(builder, DEStructures.WATCH_TOWER, Tags.Biomes.IS_COLD_OVERWORLD);
            Common.tagsStructure(builder, DEStructures.WITCH_TOWER, BiomeTags.f_207609_);
            Common.structureConfigBuilder(DEStructures.BLACK_CITADEL).pushBiomes().whitelist(new TagKey[]{BiomeTags.f_207612_}).blacklist(new ResourceKey[]{Biomes.f_48175_}).popBiomes().build(builder);
        }

        @SafeVarargs
        private static void tagsStructure(ForgeConfigSpec.Builder builder, StructureRegistrar<? extends Structure> structure, TagKey<Biome> ... tagKeys) {
            Common.structureBiomes(structure).whitelist(tagKeys).popBiomes().build(builder);
        }

        @SafeVarargs
        private static void tagsNoWaterStructure(ForgeConfigSpec.Builder builder, StructureRegistrar<? extends Structure> structure, TagKey<Biome> ... tagKeys) {
            Common.structureBiomes(structure).whitelist(tagKeys).blacklist(new TagKey[]{Tags.Biomes.IS_WATER}).popBiomes().build(builder);
        }

        @SafeVarargs
        private static void overworldExceptStructure(ForgeConfigSpec.Builder builder, StructureRegistrar<? extends Structure> structure, TagKey<Biome> ... tagKeys) {
            Common.structureBiomes(structure).whitelist(new TagKey[]{BiomeTags.f_215817_}).blacklist(tagKeys).popBiomes().build(builder);
        }

        private static void shipStructure(ForgeConfigSpec.Builder builder, StructureRegistrar<? extends Structure> structure) {
            Common.oceanExceptStructure(builder, structure, Tags.Biomes.IS_SNOWY);
        }

        @SafeVarargs
        private static void oceanExceptStructure(ForgeConfigSpec.Builder builder, StructureRegistrar<? extends Structure> structure, TagKey<Biome> ... tagKeys) {
            Common.structureBiomes(structure).whitelist(new TagKey[]{BiomeTags.f_207603_}).blacklist(tagKeys).popBiomes().build(builder);
        }

        @SafeVarargs
        private static void biomesStructure(ForgeConfigSpec.Builder builder, StructureRegistrar<? extends Structure> structure, ResourceKey<Biome> ... biomes) {
            Common.structureBiomes(structure).whitelist(biomes).popBiomes().build(builder);
        }

        private static StructureConfig.Builder.BiomeConfigBuilder structureBiomes(StructureRegistrar<? extends Structure> structure) {
            return Common.structureConfigBuilder(structure).pushBiomes();
        }

        private static StructureConfig.Builder structureConfigBuilder(StructureRegistrar<? extends Structure> structure) {
            if (structure.getStructure() == null) {
                throw new InvalidParameterException("Needs to be a single structure registrar");
            }
            return StructureConfig.builder((Registrar)structure.getStructure());
        }
    }
}

