---
navigation:
  parent: crazyae2addons_index.md
  title: 更多显示元件
  icon: crazyae2addons:tag_view_cell
categories:
  - Monitoring and Automation
item_ids:
  - crazyae2addons:tag_view_cell
  - crazyae2addons:nbt_view_cell
---
# NBT和标签显示元件

**NBT显示元件**和**标签显示元件**是一类特殊的显示元件，可以放入ME终端使其只显示符合条件的物品。

## 工作原理

* 两种显示元件都有其界面，可在其中输入**自定义过滤字符串**。
* 过滤设置保存在元件物品中，可在终端间移动且不丢失设置。
* 放入终端后，仅会显示匹配过滤的物品。

## NBT显示元件

* 将物品的**NBT数据**与过滤表达式匹配，以此来进行过滤。
* 可在`{ ... }`内写入SNBT片段，并可搭配逻辑运算符使用。
* **支持的运算符：**
    * `&&`、`and` → 与
    * `||`、`or` → 或
    * `^^`、`xor` → 异或
    * `!`、`not` → 非
    * `nand`、`!&` → 与非
* 小括号`( )`可用于给表达式分组。
* 通配符`*`可匹配任意值和任意键。
* 示例：`{Enchantments:[{id:"minecraft:sharpness"}]}`只会匹配拥有锋利魔咒的物品。

## 标签显示元件

* 使用**Minecraft标签**过滤物品。
* 输入标签名（如`#minecraft:wool`），终端便只会显示带有该标签的物品。
* 支持使用`*`的**glob模式匹配**，如`#minecraft:*_logs`会匹配所有原木标签。
* 支持逻辑运算符：
    * `&&`、`||`、`^^`、`!`、`nand`
* 示例：`#minecraft:logs && !#minecraft:oak_logs` → 匹配所有原木，橡木原木除外。

## 界面

* 打开元件可进行配置：

    * 用于输入过滤表达式的文本框。
    * 如果过滤表达式过长，无法在框内完全显示，可以使用**滚动条**。
    * 按下**确认按钮**以保存过滤配置。
* 过滤配置会立即应用于元件，配置本身也会同时存入物品。

## 注意事项

* 这些元件只会影响**终端的显示**，不会把物品移出网络，也不会阻止物品进入。
* 多个显示元件的效果可以综合，过滤设置的应用规则与AE2优先级一致。
* 若未设置过滤，则该元件装入与否不会产生区别。

---

NBT和标签显示元件可保持终端简洁，聚焦所需内容。无论是筛选特定种类药水，还是某标签下的全部方块，它们都能胜任。
