/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.village.wanderer;

import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.affix.trades.AffixTrade;
import dev.shadowsoffire.apotheosis.village.VillageModule;
import dev.shadowsoffire.apotheosis.village.wanderer.JsonTrade;
import dev.shadowsoffire.apotheosis.village.wanderer.WandererTrade;
import dev.shadowsoffire.placebo.reload.DynamicRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraftforge.common.BasicItemListing;

public class WandererTradesRegistry
extends DynamicRegistry<JsonTrade> {
    public static final WandererTradesRegistry INSTANCE = new WandererTradesRegistry();
    protected final Map<ResourceLocation, BasicItemListing> registry = new HashMap<ResourceLocation, BasicItemListing>();
    protected final List<VillagerTrades.ItemListing> normTrades = new ArrayList<VillagerTrades.ItemListing>();
    protected final List<VillagerTrades.ItemListing> rareTrades = new ArrayList<VillagerTrades.ItemListing>();

    public WandererTradesRegistry() {
        super(VillageModule.LOGGER, "wanderer_trades", false, true);
    }

    protected void registerBuiltinCodecs() {
        this.registerDefaultCodec(Apotheosis.loc("basic_trade"), WandererTrade.CODEC);
        this.registerCodec(Apotheosis.loc("affix"), AffixTrade.CODEC);
    }

    protected void beginReload() {
        super.beginReload();
        this.normTrades.clear();
        this.rareTrades.clear();
    }

    protected void onReload() {
        super.onReload();
        this.getValues().forEach(trade -> {
            if (trade.isRare()) {
                this.rareTrades.add((VillagerTrades.ItemListing)trade);
            } else {
                this.normTrades.add((VillagerTrades.ItemListing)trade);
            }
        });
    }

    public List<VillagerTrades.ItemListing> getNormalTrades() {
        return this.normTrades;
    }

    public List<VillagerTrades.ItemListing> getRareTrades() {
        return this.rareTrades;
    }
}

