/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.village.fletching.arrows;

import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.util.BlockUtil;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;

public class MiningArrowEntity
extends AbstractArrow
implements IEntityAdditionalSpawnData {
    protected int blocksBroken = 0;
    protected UUID playerId = null;
    protected ItemStack breakerItem = ItemStack.f_41583_;
    protected Type type = Type.IRON;

    public MiningArrowEntity(EntityType<? extends AbstractArrow> t, Level world) {
        super(t, world);
        this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
    }

    public MiningArrowEntity(Level world) {
        this((EntityType<? extends AbstractArrow>)((EntityType)Apoth.Entities.MINING_ARROW.get()), world);
    }

    public MiningArrowEntity(LivingEntity shooter, Level world, ItemStack breakerItem, Type type) {
        super((EntityType)Apoth.Entities.MINING_ARROW.get(), shooter, world);
        this.breakerItem = breakerItem;
        this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
        this.type = type;
        this.playerId = shooter.m_20148_();
    }

    public MiningArrowEntity(Level world, double x, double y, double z, ItemStack breakerItem, Type type) {
        super((EntityType)Apoth.Entities.MINING_ARROW.get(), x, y, z, world);
        this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
        this.breakerItem = breakerItem;
        this.type = type;
    }

    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_8119_() {
        VoxelShape voxelshape;
        if (!this.m_9236_().f_46443_) {
            this.m_20115_(6, this.m_142038_());
        }
        this.m_6075_();
        boolean noClip = this.m_36797_();
        Vec3 motion = this.m_20184_();
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            double d0 = motion.m_165924_();
            this.m_146922_((float)(Mth.m_14136_((double)motion.f_82479_, (double)motion.f_82481_) * 57.2957763671875));
            this.m_146926_((float)(Mth.m_14136_((double)motion.f_82480_, (double)d0) * 57.2957763671875));
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
        BlockPos blockpos = this.m_20183_();
        BlockState blockstate = this.m_9236_().m_8055_(blockpos);
        if (!(blockstate.m_60795_() || noClip || (voxelshape = blockstate.m_60812_((BlockGetter)this.m_9236_(), blockpos)).m_83281_())) {
            Vec3 vec31 = this.m_20182_();
            for (AABB aabb : voxelshape.m_83299_()) {
                if (!aabb.m_82338_(blockpos).m_82390_(vec31)) continue;
                this.f_36703_ = true;
                break;
            }
        }
        if (this.f_36706_ > 0) {
            --this.f_36706_;
        }
        if (this.m_20070_() || blockstate.m_60713_(Blocks.f_152499_)) {
            this.m_20095_();
        }
        if (this.f_36703_) {
            this.m_146870_();
        } else {
            BlockHitResult traceResult;
            this.f_36704_ = 0;
            Vec3 pos = this.m_20182_();
            Vec3 posNextTick = pos.m_82549_(motion);
            int iterations = 0;
            while (!this.m_9236_().f_46443_ && this.m_6084_() && (traceResult = this.m_9236_().m_45547_(new ClipContext(pos, posNextTick, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this))).m_6662_() != HitResult.Type.MISS) {
                if (traceResult.m_6662_() == HitResult.Type.BLOCK) {
                    this.m_6532_((HitResult)traceResult);
                }
                if (iterations++ <= 10) continue;
                break;
            }
            motion = this.m_20184_();
            double dX = motion.f_82479_;
            double dY = motion.f_82480_;
            double dZ = motion.f_82481_;
            if (this.m_36792_()) {
                for (int i = 0; i < 4; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123797_, this.m_20185_() + dX * (double)i / 4.0, this.m_20186_() + dY * (double)i / 4.0, this.m_20189_() + dZ * (double)i / 4.0, -dX, -dY + 0.2, -dZ);
                }
            }
            double nextX = this.m_20185_() + dX;
            double nextY = this.m_20186_() + dY;
            double nextZ = this.m_20189_() + dZ;
            double hDist = motion.m_165924_();
            if (noClip) {
                this.m_146922_((float)(Mth.m_14136_((double)(-dX), (double)(-dZ)) * 57.2957763671875));
            } else {
                this.m_146922_((float)(Mth.m_14136_((double)dX, (double)dZ) * 57.2957763671875));
            }
            this.m_146926_((float)(Mth.m_14136_((double)dY, (double)hDist) * 57.2957763671875));
            this.m_146926_(MiningArrowEntity.m_37273_((float)this.f_19860_, (float)this.m_146909_()));
            this.m_146922_(MiningArrowEntity.m_37273_((float)this.f_19859_, (float)this.m_146908_()));
            float f = 0.99f;
            if (this.m_20069_()) {
                for (int j = 0; j < 4; ++j) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, nextX - dX * 0.25, nextY - dY * 0.25, nextZ - dZ * 0.25, dX, dY, dZ);
                }
                f = this.m_6882_();
            }
            this.m_20256_(motion.m_82490_((double)f));
            if (!this.m_20068_() && !noClip) {
                Vec3 vec34 = this.m_20184_();
                this.m_20334_(vec34.f_82479_, vec34.f_82480_ - (double)0.05f, vec34.f_82481_);
            }
            this.m_6034_(nextX, nextY, nextZ);
        }
    }

    protected void m_8060_(BlockHitResult res) {
        this.breakBlock(res.m_82425_());
    }

    public boolean m_20068_() {
        return false;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("blocks_broken", this.blocksBroken);
        if (this.playerId != null) {
            compound.m_128362_("player_id", this.playerId);
        }
        compound.m_128365_("breaker_item", (Tag)this.breakerItem.serializeNBT());
        compound.m_128344_("arrow_type", (byte)this.type.ordinal());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.blocksBroken = compound.m_128451_("blocks_broken");
        if (compound.m_128441_("player_id")) {
            this.playerId = compound.m_128342_("player_id");
        }
        this.breakerItem = ItemStack.m_41712_((CompoundTag)compound.m_128469_("breaker_item"));
        this.type = Type.values()[compound.m_128445_("arrow_type")];
    }

    public void writeSpawnData(FriendlyByteBuf buf) {
        buf.writeByte(this.type.ordinal());
    }

    public void readSpawnData(FriendlyByteBuf buf) {
        this.type = Type.values()[buf.readByte()];
    }

    protected void breakBlock(BlockPos pos) {
        if (!this.m_9236_().f_46443_ && !this.m_9236_().m_8055_(pos).m_60795_()) {
            if (BlockUtil.breakExtraBlock((ServerLevel)this.m_9236_(), pos, this.breakerItem, this.playerId)) {
                if (++this.blocksBroken >= 12) {
                    this.m_146870_();
                }
            } else {
                this.m_5496_(SoundEvents.f_11669_, 1.0f, 1.5f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
                this.m_146870_();
            }
        }
    }

    public static enum Type {
        IRON(new ResourceLocation("apotheosis", "textures/entity/iron_mining_arrow.png")),
        DIAMOND(new ResourceLocation("apotheosis", "textures/entity/diamond_mining_arrow.png"));

        private final ResourceLocation texture;

        private Type(ResourceLocation texture) {
            this.texture = texture;
        }

        public ResourceLocation getTexture() {
            return this.texture;
        }
    }
}

