/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.util;

import com.google.common.base.Predicates;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.ench.api.IEnchantingBlock;
import dev.shadowsoffire.apotheosis.ench.table.ApothEnchantmentMenu;
import dev.shadowsoffire.apotheosis.ench.table.EnchantingStatRegistry;
import dev.shadowsoffire.attributeslib.AttributesLib;
import dev.shadowsoffire.attributeslib.api.IFormattableAttribute;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;

public class CommonTooltipUtil {
    public static void appendBossData(Level level, LivingEntity entity, Consumer<Component> tooltip) {
        DynamicHolder<LootRarity> rarity = RarityRegistry.byLegacyId(entity.getPersistentData().m_128461_("apoth.rarity"));
        if (!rarity.isBound()) {
            return;
        }
        tooltip.accept((Component)Component.m_237110_((String)"info.apotheosis.boss", (Object[])new Object[]{((LootRarity)rarity.get()).toComponent()}).m_130940_(ChatFormatting.GRAY));
        if (FMLEnvironment.production) {
            return;
        }
        tooltip.accept(CommonComponents.f_237098_);
        tooltip.accept((Component)Component.m_237115_((String)"info.apotheosis.boss_modifiers").m_130940_(ChatFormatting.GRAY));
        AttributeMap map = entity.m_21204_();
        ForgeRegistries.ATTRIBUTES.getValues().stream().map(arg_0 -> ((AttributeMap)map).m_22146_(arg_0)).filter((Predicate<AttributeInstance>)Predicates.notNull()).forEach(inst -> {
            for (AttributeModifier modif : inst.m_22122_()) {
                if (!modif.m_22214_().startsWith("placebo_random_modifier_")) continue;
                tooltip.accept((Component)IFormattableAttribute.toComponent((Attribute)inst.m_22099_(), (AttributeModifier)modif, (TooltipFlag)AttributesLib.getTooltipFlag()));
            }
        });
    }

    public static void appendBlockStats(Level world, BlockState state, BlockPos pos, Consumer<Component> tooltip) {
        Set<Enchantment> blacklist;
        float maxEterna = EnchantingStatRegistry.getMaxEterna(state, world, pos);
        float eterna = EnchantingStatRegistry.getEterna(state, world, pos);
        float quanta = EnchantingStatRegistry.getQuanta(state, world, pos);
        float arcana = EnchantingStatRegistry.getArcana(state, world, pos);
        float rectification = EnchantingStatRegistry.getQuantaRectification(state, world, pos);
        int clues = EnchantingStatRegistry.getBonusClues(state, world, pos);
        boolean treasure = ((IEnchantingBlock)state.m_60734_()).allowsTreasure(state, (LevelReader)world, pos);
        if (eterna != 0.0f || quanta != 0.0f || arcana != 0.0f || rectification != 0.0f || clues != 0) {
            tooltip.accept((Component)Component.m_237115_((String)"info.apotheosis.ench_stats").m_130940_(ChatFormatting.GOLD));
        }
        if (eterna != 0.0f) {
            if (eterna > 0.0f) {
                tooltip.accept((Component)Component.m_237110_((String)"info.apotheosis.eterna.p", (Object[])new Object[]{String.format("%.2f", Float.valueOf(eterna)), String.format("%.2f", Float.valueOf(maxEterna))}).m_130940_(ChatFormatting.GREEN));
            } else {
                tooltip.accept((Component)Component.m_237110_((String)"info.apotheosis.eterna", (Object[])new Object[]{String.format("%.2f", Float.valueOf(eterna))}).m_130940_(ChatFormatting.GREEN));
            }
        }
        if (quanta != 0.0f) {
            tooltip.accept((Component)Component.m_237110_((String)("info.apotheosis.quanta" + (quanta > 0.0f ? ".p" : "")), (Object[])new Object[]{String.format("%.2f", Float.valueOf(quanta))}).m_130940_(ChatFormatting.RED));
        }
        if (arcana != 0.0f) {
            tooltip.accept((Component)Component.m_237110_((String)("info.apotheosis.arcana" + (arcana > 0.0f ? ".p" : "")), (Object[])new Object[]{String.format("%.2f", Float.valueOf(arcana))}).m_130940_(ChatFormatting.DARK_PURPLE));
        }
        if (rectification != 0.0f) {
            tooltip.accept((Component)Component.m_237110_((String)("info.apotheosis.rectification" + (rectification > 0.0f ? ".p" : "")), (Object[])new Object[]{String.format("%.2f", Float.valueOf(rectification))}).m_130940_(ChatFormatting.YELLOW));
        }
        if (clues != 0) {
            tooltip.accept((Component)Component.m_237110_((String)("info.apotheosis.clues" + (clues > 0 ? ".p" : "")), (Object[])new Object[]{String.format("%d", clues)}).m_130940_(ChatFormatting.DARK_AQUA));
        }
        if (treasure) {
            tooltip.accept((Component)Component.m_237115_((String)"info.apotheosis.allows_treasure").m_130940_(ChatFormatting.GOLD));
        }
        if ((blacklist = ((IEnchantingBlock)state.m_60734_()).getBlacklistedEnchantments(state, (LevelReader)world, pos)).size() > 0) {
            tooltip.accept((Component)Component.m_237115_((String)"info.apotheosis.filter").m_130938_(s -> s.m_178520_(5812428)));
            for (Enchantment e : blacklist) {
                MutableComponent name = (MutableComponent)e.m_44700_(1);
                name.m_7360_().clear();
                name.m_130938_(s -> s.m_178520_(5798058));
                tooltip.accept((Component)Component.m_237113_((String)" - ").m_7220_((Component)name).m_130938_(s -> s.m_178520_(5798058)));
            }
        }
    }

    public static void appendTableStats(Level world, BlockPos pos, Consumer<Component> tooltip) {
        ApothEnchantmentMenu.TableStats stats = ApothEnchantmentMenu.gatherStats(world, pos, 0);
        tooltip.accept((Component)Component.m_237110_((String)"info.apotheosis.eterna.t", (Object[])new Object[]{String.format("%.2f", Float.valueOf(stats.eterna())), String.format("%.2f", Float.valueOf(EnchantingStatRegistry.getAbsoluteMaxEterna()))}).m_130940_(ChatFormatting.GREEN));
        tooltip.accept((Component)Component.m_237110_((String)"info.apotheosis.quanta.t", (Object[])new Object[]{String.format("%.2f", Float.valueOf(Math.min(100.0f, stats.quanta())))}).m_130940_(ChatFormatting.RED));
        tooltip.accept((Component)Component.m_237110_((String)"info.apotheosis.arcana.t", (Object[])new Object[]{String.format("%.2f", Float.valueOf(Math.min(100.0f, stats.arcana())))}).m_130940_(ChatFormatting.DARK_PURPLE));
        tooltip.accept((Component)Component.m_237110_((String)"info.apotheosis.rectification.t", (Object[])new Object[]{String.format("%.2f", Float.valueOf(Mth.m_14036_((float)stats.rectification(), (float)-100.0f, (float)100.0f)))}).m_130940_(ChatFormatting.YELLOW));
        tooltip.accept((Component)Component.m_237110_((String)"info.apotheosis.clues.t", (Object[])new Object[]{String.format("%d", stats.clues())}).m_130940_(ChatFormatting.DARK_AQUA));
    }
}

