/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.boss;

import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.adventure.AdventureModule;
import dev.shadowsoffire.apotheosis.adventure.boss.ApothBoss;
import dev.shadowsoffire.apotheosis.adventure.boss.BossRegistry;
import dev.shadowsoffire.apotheosis.adventure.compat.GameStagesCompat;
import dev.shadowsoffire.placebo.block_entity.TickingBlockEntity;
import dev.shadowsoffire.placebo.block_entity.TickingEntityBlock;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.reload.WeightedDynamicRegistry;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BossSpawnerBlock
extends Block
implements TickingEntityBlock {
    private static final VoxelShape OCC_SHAPE = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)15.99, (double)0.0);

    public BossSpawnerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new BossSpawnerTile(pPos, pState);
    }

    public VoxelShape m_7952_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return OCC_SHAPE;
    }

    public static class BossSpawnerTile
    extends BlockEntity
    implements TickingBlockEntity {
        protected DynamicHolder<ApothBoss> item = BossRegistry.INSTANCE.emptyHolder();
        protected int ticks = 0;

        public BossSpawnerTile(BlockPos pos, BlockState state) {
            super((BlockEntityType)Apoth.Tiles.BOSS_SPAWNER.get(), pos, state);
        }

        public void serverTick(Level pLevel, BlockPos pPos, BlockState pState) {
            if (this.ticks++ % 40 == 0) {
                Optional opt = this.f_58857_.m_142425_((EntityTypeTest)EntityType.f_20532_, new AABB(this.f_58858_).m_82377_(8.0, 8.0, 8.0), EntitySelector.f_20406_).stream().findFirst();
                opt.ifPresent(player -> {
                    ApothBoss bossItem;
                    this.f_58857_.m_46597_(this.f_58858_, Blocks.f_50016_.m_49966_());
                    BlockPos pos = this.f_58858_;
                    ApothBoss apothBoss = bossItem = !this.item.isBound() ? (ApothBoss)BossRegistry.INSTANCE.getRandomItem(this.f_58857_.m_213780_(), player.m_36336_(), new Predicate[]{WeightedDynamicRegistry.IDimensional.matches((Level)this.f_58857_), GameStagesCompat.IStaged.matches(player)}) : (ApothBoss)this.item.get();
                    if (bossItem == null) {
                        AdventureModule.LOGGER.error("A boss spawner attempted to spawn a boss at {} in {}, but no bosses were available!", (Object)this.m_58899_(), (Object)this.f_58857_.m_46472_().m_135782_());
                        return;
                    }
                    Mob entity = bossItem.createBoss((ServerLevelAccessor)((ServerLevel)this.f_58857_), pos, this.f_58857_.m_213780_(), player.m_36336_());
                    entity.m_6710_((LivingEntity)player);
                    entity.m_21530_();
                    ((ServerLevel)this.f_58857_).m_47205_((Entity)entity);
                });
            }
        }

        public void setBossItem(DynamicHolder<ApothBoss> item) {
            this.item = item;
        }

        public void m_183515_(CompoundTag tag) {
            if (this.item != null) {
                tag.m_128359_("boss_item", this.item.getId().toString());
            }
            super.m_183515_(tag);
        }

        public void m_142466_(CompoundTag tag) {
            this.item = BossRegistry.INSTANCE.holder(new ResourceLocation(tag.m_128461_("boss_item")));
            super.m_142466_(tag);
        }
    }
}

