/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2artifacts.init.data.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.xkmc.l2artifacts.compat.L2HostilityCompat;
import dev.xkmc.l2artifacts.init.data.ArtifactConfig;
import dev.xkmc.l2artifacts.init.data.ArtifactTagGen;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class ArtifactLootModifier
extends LootModifier {
    public static final Codec<ArtifactLootModifier> CODEC = RecordCodecBuilder.create(i -> ArtifactLootModifier.codecStart((RecordCodecBuilder.Instance)i).and(i.group((App)Codec.INT.fieldOf("healthMin").forGetter(e -> e.healthMin), (App)Codec.INT.fieldOf("healthMax").forGetter(e -> e.healthMax), (App)Codec.DOUBLE.fieldOf("chance").forGetter(e -> e.chance), (App)ItemStack.f_41582_.fieldOf("result").forGetter(e -> e.result))).apply((Applicative)i, ArtifactLootModifier::new));
    private final int healthMin;
    private final int healthMax;
    private final double chance;
    private final ItemStack result;

    public ArtifactLootModifier(int healthMin, int healthMax, double chance, ItemStack result, LootItemCondition ... conditionsIn) {
        super(conditionsIn);
        this.healthMin = healthMin;
        this.healthMax = healthMax;
        this.chance = chance;
        this.result = result;
    }

    private ArtifactLootModifier(LootItemCondition[] conditionsIn, int healthMin, int healthMax, double chance, ItemStack result) {
        super(conditionsIn);
        this.healthMin = healthMin;
        this.healthMax = healthMax;
        this.chance = chance;
        this.result = result;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> list, LootContext context) {
        LivingEntity le;
        if (!context.m_78936_(LootContextParams.f_81455_)) {
            return list;
        }
        Entity entity = (Entity)context.m_165124_(LootContextParams.f_81455_);
        if (entity.m_6095_().m_204039_(ArtifactTagGen.NO_DROP)) {
            return list;
        }
        if (entity instanceof LivingEntity && L2HostilityCompat.validForDrop(le = (LivingEntity)entity, this.healthMin, this.healthMax) && this.chance * (Double)ArtifactConfig.COMMON.globalDropChanceMultiplier.get() > context.m_230907_().m_188500_()) {
            list.add((Object)this.result.m_41777_());
        }
        return list;
    }

    public Codec<ArtifactLootModifier> codec() {
        return CODEC;
    }
}

