/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2artifacts.content.swap;

import dev.xkmc.l2artifacts.content.swap.ArtifactSwapData;
import dev.xkmc.l2artifacts.content.swap.ArtifactSwapItem;
import dev.xkmc.l2library.base.menu.base.BaseContainerMenu;
import dev.xkmc.l2library.base.menu.base.SpriteManager;
import dev.xkmc.l2library.base.menu.data.BoolArrayDataSlot;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;

public class ArtifactSwapMenu
extends BaseContainerMenu<ArtifactSwapMenu> {
    public static final SpriteManager MANAGER = new SpriteManager("l2artifacts", "swap");
    private final int slot;
    private final ItemStack stack;
    public final ArtifactSwapData data;
    public final BoolArrayDataSlot disable = new BoolArrayDataSlot((AbstractContainerMenu)this, 45);
    private boolean init = false;

    public static ArtifactSwapMenu fromNetwork(MenuType<ArtifactSwapMenu> type, int wid, Inventory plInv, FriendlyByteBuf buf) {
        int i = buf.readInt();
        return new ArtifactSwapMenu(type, wid, plInv, i);
    }

    protected ArtifactSwapMenu(MenuType<?> type, int wid, Inventory plInv, int slot) {
        super(type, wid, plInv, MANAGER, e -> new BaseContainerMenu.BaseContainer(45, (BaseContainerMenu)e), false);
        this.slot = slot;
        this.stack = plInv.f_35978_.m_150109_().m_8020_(slot);
        this.data = ArtifactSwapItem.getData(this.stack);
        this.addSlot("grid", (i, st) -> this.data.contents[i].canAccept((ItemStack)st));
        this.reload();
        this.init = true;
    }

    private void reload() {
        this.init = false;
        for (int i = 0; i < 45; ++i) {
            this.container.m_6836_(i, this.data.contents[i].getStack().m_41777_());
            this.disable.set(this.data.contents[i].isLocked(), i);
        }
        this.init = true;
    }

    public boolean m_6366_(Player player, int id) {
        if (id >= 0 && id < 45) {
            if (!player.m_9236_().m_5776_()) {
                this.data.contents[id].toggle();
                this.save();
                this.reload();
            }
            return true;
        }
        return false;
    }

    private void save() {
        if (!this.init || this.inventory.f_35978_.m_9236_().m_5776_()) {
            return;
        }
        for (int i = 0; i < 45; ++i) {
            this.data.contents[i].setStack(this.container.m_8020_(i).m_41777_());
        }
        ArtifactSwapItem.setData(this.stack, this.data);
    }

    protected void securedServerSlotChange(Container cont) {
        if (this.init) {
            this.save();
        }
    }

    public boolean m_6875_(Player player) {
        return player.m_150109_().m_8020_(this.slot) == this.stack;
    }
}

