/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2artifacts.content.search.augment;

import dev.xkmc.l2artifacts.content.core.ArtifactStats;
import dev.xkmc.l2artifacts.content.core.BaseArtifact;
import dev.xkmc.l2artifacts.content.core.StatEntry;
import dev.xkmc.l2artifacts.content.search.augment.AugmentMenu;
import dev.xkmc.l2artifacts.content.search.filter.FilterScreen;
import dev.xkmc.l2artifacts.content.search.recycle.RecycleMenuScreen;
import dev.xkmc.l2artifacts.content.search.tabs.FilterTabManager;
import dev.xkmc.l2artifacts.content.search.tabs.IFilterScreen;
import dev.xkmc.l2artifacts.content.upgrades.StatContainerItem;
import dev.xkmc.l2artifacts.init.data.LangData;
import dev.xkmc.l2library.base.menu.base.BaseContainerMenu;
import dev.xkmc.l2library.base.menu.base.BaseContainerScreen;
import dev.xkmc.l2library.base.menu.base.MenuLayoutConfig;
import dev.xkmc.l2library.base.menu.stacked.StackedRenderHandle;
import dev.xkmc.l2library.util.Proxy;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class AugmentMenuScreen
extends BaseContainerScreen<AugmentMenu>
implements IFilterScreen {
    private static final int MAX_TIME = 60;
    private static final ChatFormatting MAIN = ChatFormatting.DARK_GREEN;
    private static final ChatFormatting SUB = ChatFormatting.BLUE;
    private static final ChatFormatting LIT = ChatFormatting.RED;
    private boolean pressed = false;
    private float time = 0.0f;
    @Nullable
    private ArtifactStats old = null;
    @Nullable
    private ArtifactStats current = null;
    private ItemStack oldStack = ItemStack.f_41583_;
    private boolean keep = false;

    private static int lerpColor(float perc, int fg, int bg) {
        int c0 = Math.round(Mth.m_14179_((float)perc, (float)(fg & 0xFF), (float)(bg & 0xFF)));
        int c1 = Math.round(Mth.m_14179_((float)perc, (float)((fg >>= 8) & 0xFF), (float)((bg >>= 8) & 0xFF)));
        int c2 = Math.round(Mth.m_14179_((float)perc, (float)((fg >>= 8) & 0xFF), (float)((bg >>= 8) & 0xFF)));
        return c2 << 16 | c1 << 8 | c0;
    }

    public AugmentMenuScreen(AugmentMenu cont, Inventory plInv, Component title) {
        super((BaseContainerMenu)cont, plInv, (Component)LangData.TAB_AUGMENT.get(new Object[0]).m_130940_(ChatFormatting.GRAY));
    }

    protected final void m_7856_() {
        super.m_7856_();
        new FilterTabManager(this, ((AugmentMenu)this.f_97732_).token).init(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        }, FilterTabManager.AUGMENT);
    }

    protected void m_7286_(GuiGraphics g, float pTick, int mx, int my) {
        MenuLayoutConfig.ScreenRenderer sr = ((AugmentMenu)this.f_97732_).sprite.get().getRenderer((AbstractContainerScreen)this);
        sr.start(g);
        int mask = ((AugmentMenu)this.f_97732_).mask.get();
        if ((mask & 1) > 0) {
            sr.draw(g, "in_0", "toggle_slot_1", -1, -1);
        }
        if ((mask & 2) > 0) {
            sr.draw(g, "in_1", "toggle_slot_1", -1, -1);
        }
        if ((mask & 4) > 0) {
            sr.draw(g, "in_2", "toggle_slot_1", -1, -1);
        }
        if (((AugmentMenu)this.f_97732_).container.m_8020_(1).m_41619_()) {
            sr.draw(g, "in_0", "altas_stat_container");
        }
        if (((AugmentMenu)this.f_97732_).container.m_8020_(2).m_41619_()) {
            sr.draw(g, "in_1", "altas_boost_main");
        }
        if (((AugmentMenu)this.f_97732_).container.m_8020_(3).m_41619_()) {
            sr.draw(g, "in_2", "altas_boost_sub");
        }
        MenuLayoutConfig.Rect rect = ((AugmentMenu)this.f_97732_).sprite.get().getComp("upgrade");
        if (this.m_6774_(rect.x, rect.y, rect.w, rect.h, mx, my)) {
            if (this.pressed) {
                sr.draw(g, "upgrade", "upgrade_on");
            }
            FilterScreen.renderHighlight(g, this.f_97735_ + rect.x, this.f_97736_ + rect.y, rect.w, rect.h, -2130706433);
        }
        if (this.time > 0.0f) {
            this.time -= Minecraft.m_91087_().m_91297_();
            if (this.time <= 0.0f) {
                this.time = 0.0f;
                this.old = null;
            }
        }
    }

    public boolean m_6375_(double mx, double my, int btn) {
        this.pressed = true;
        return super.m_6375_(mx, my, btn);
    }

    public boolean m_6348_(double mx, double my, int btn) {
        this.pressed = false;
        MenuLayoutConfig.Rect rect = ((AugmentMenu)this.f_97732_).sprite.get().getComp("upgrade");
        if (this.m_6774_(rect.x, rect.y, rect.w, rect.h, mx, my)) {
            this.old = this.current;
            this.time = 60.0f;
            this.keep = this.click(0);
        }
        return super.m_6348_(mx, my, btn);
    }

    protected void m_280003_(GuiGraphics g, int mx, int my) {
        g.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, 0x404040, false);
        g.m_280614_(this.f_96547_, (Component)this.f_169604_.m_6881_().m_130940_(ChatFormatting.GRAY), this.f_97730_, this.f_97731_, 0x404040, false);
        g.m_280168_().m_85836_();
        g.m_280168_().m_252880_(0.0f, 45.0f, 0.0f);
        StackedRenderHandle handle = new StackedRenderHandle((Screen)this, g, ((AugmentMenu)this.f_97732_).sprite.get(), 0);
        int exp = ((AugmentMenu)this.f_97732_).experience.get();
        int cost = ((AugmentMenu)this.f_97732_).exp_cost.get();
        if (cost > 0) {
            Optional<ArtifactStats> opt;
            String str = RecycleMenuScreen.formatNumber(cost) + "/" + RecycleMenuScreen.formatNumber(exp);
            handle.drawText((Component)LangData.TAB_INFO_EXP_COST.get(Component.m_237113_((String)str).m_130940_(cost <= exp ? ChatFormatting.DARK_GREEN : ChatFormatting.RED)).m_130940_(ChatFormatting.GRAY), false);
            ItemStack stack = ((AugmentMenu)this.f_97732_).container.m_8020_(0);
            if (stack != this.oldStack) {
                this.oldStack = stack;
                if (this.keep) {
                    this.keep = false;
                } else {
                    this.old = null;
                }
            }
            if ((opt = BaseArtifact.getStats(stack)).isPresent()) {
                ArtifactStats stat = opt.get();
                ArrayList<Component[]> table = new ArrayList<Component[]>();
                table.add(this.addEntry(true, stat.main_stat, this.old == null ? null : this.old.main_stat, false, (((AugmentMenu)this.f_97732_).mask.get() & 2) > 0));
                boolean display = this.old != null && this.old.sub_stats.size() == stat.sub_stats.size();
                for (int i = 0; i < stat.sub_stats.size(); ++i) {
                    int I = i;
                    boolean stat_exist = (((AugmentMenu)this.f_97732_).mask.get() & 1) > 0;
                    boolean lit_name = stat_exist && StatContainerItem.getType(((AugmentMenu)this.f_97732_).container.m_8020_(1)).map(e -> e.equals((Object)stat.sub_stats.get((int)I).type)).orElse(false) != false;
                    boolean boost_sub = (((AugmentMenu)this.f_97732_).mask.get() & 4) > 0;
                    boolean lit_stat = boost_sub && (!stat_exist || lit_name);
                    table.add(this.addEntry(false, stat.sub_stats.get(i), !display ? null : this.old.sub_stats.get(i), lit_name, lit_stat));
                }
                handle.drawTable((Component[][])table.toArray(x$0 -> new Component[x$0][]), this.f_97726_, false);
                this.current = stat;
            }
        } else {
            handle.drawText((Component)LangData.TAB_INFO_EXP.get(exp).m_130940_(ChatFormatting.GRAY), false);
        }
        handle.flushText();
        g.m_280168_().m_85849_();
    }

    private Component[] addEntry(boolean main, StatEntry entry, @Nullable StatEntry old, boolean lit_name, boolean lit_stat) {
        Component[] ans = new Component[3];
        if (Proxy.getClientPlayer().f_19797_ % 20 < 10) {
            lit_stat = false;
            lit_name = false;
        }
        ans[0] = Component.m_237115_((String)entry.getType().attr.m_22087_()).m_130940_(lit_name ? LIT : (main ? MAIN : SUB));
        ans[1] = entry.getType().getValueText(entry.getValue()).m_130940_(lit_stat ? LIT : (main ? MAIN : SUB));
        if (old != null) {
            double diff = entry.getValue() - old.getValue();
            if (diff > 0.001) {
                Integer fg = ChatFormatting.DARK_PURPLE.m_126665_();
                assert (fg != null);
                float perc = 1.0f - this.time / 60.0f;
                int c = AugmentMenuScreen.lerpColor(perc, fg, 0x33322E);
                ans[2] = entry.getType().getValueText(diff).m_130948_(Style.f_131099_.m_178520_(c));
            } else {
                ans[2] = Component.m_237119_();
            }
        } else {
            ans[2] = Component.m_237119_();
        }
        entry.getTooltip();
        return ans;
    }

    @Override
    public int screenWidth() {
        return this.f_96543_;
    }

    @Override
    public int screenHeight() {
        return this.f_96544_;
    }
}

