/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2artifacts.content.effects.v4;

import dev.xkmc.l2artifacts.content.config.ArtifactSetConfig;
import dev.xkmc.l2artifacts.content.effects.core.SetEffect;
import dev.xkmc.l2artifacts.content.mobeffects.EffectDesc;
import dev.xkmc.l2artifacts.init.registrate.entries.LinearFuncEntry;
import dev.xkmc.l2damagetracker.contents.attack.AttackCache;
import dev.xkmc.l2damagetracker.contents.attack.DamageModifier;
import dev.xkmc.l2damagetracker.init.data.L2DamageTypes;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class AbyssAttackEffect
extends SetEffect {
    private final LinearFuncEntry duration;
    private final LinearFuncEntry level;
    private final LinearFuncEntry hurt;

    public AbyssAttackEffect(LinearFuncEntry duration, LinearFuncEntry level, LinearFuncEntry hurt, int ids) {
        super(ids);
        this.duration = duration;
        this.level = level;
        this.hurt = hurt;
    }

    private MobEffectInstance weak(int rank) {
        return new MobEffectInstance(MobEffects.f_19613_, (int)this.duration.getFromRank(rank), (int)this.level.getFromRank(rank));
    }

    private MobEffectInstance wither(int rank) {
        return new MobEffectInstance(MobEffects.f_19615_, (int)this.duration.getFromRank(rank), (int)this.level.getFromRank(rank));
    }

    @Override
    public void playerHurtOpponentEvent(LivingEntity player, ArtifactSetConfig.Entry ent, int rank, AttackCache event) {
        event.getAttackTarget().m_147207_(this.weak(rank), (Entity)player);
        event.getAttackTarget().m_147207_(this.wither(rank), (Entity)player);
    }

    @Override
    public void playerReduceDamage(LivingEntity player, ArtifactSetConfig.Entry ent, int rank, DamageSource source, AttackCache cache) {
        if (source.m_269533_(L2DamageTypes.MAGIC)) {
            cache.addDealtModifier(DamageModifier.multTotal((float)(1.0f - (float)this.hurt.getFromRank(rank))));
        }
    }

    @Override
    public List<MutableComponent> getDetailedDescription(int rank) {
        int val = (int)Math.round(this.hurt.getFromRank(rank) * 100.0);
        return List.of(Component.m_237110_((String)(this.getDescriptionId() + ".desc"), (Object[])new Object[]{EffectDesc.getDesc(this.weak(rank), true), EffectDesc.getDesc(this.wither(rank), true), val}));
    }
}

