/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2artifacts.content.core;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import dev.xkmc.l2artifacts.content.core.ArtifactSlot;
import dev.xkmc.l2artifacts.content.core.StatEntry;
import dev.xkmc.l2artifacts.content.upgrades.ArtifactUpgradeManager;
import dev.xkmc.l2artifacts.content.upgrades.Upgrade;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

@SerialClass
public class ArtifactStats {
    @SerialClass.SerialField
    public ArtifactSlot slot;
    @SerialClass.SerialField
    public int rank;
    @SerialClass.SerialField
    public int level;
    @SerialClass.SerialField
    public int exp;
    @SerialClass.SerialField
    public int old_level;
    @SerialClass.SerialField
    public StatEntry main_stat;
    @SerialClass.SerialField
    public ArrayList<StatEntry> sub_stats = new ArrayList();
    public final Map<ResourceLocation, StatEntry> map = new HashMap<ResourceLocation, StatEntry>();

    public static ArtifactStats generate(ArtifactSlot slot, int rank, Upgrade upgrade, RandomSource random) {
        ArtifactStats ans = new ArtifactStats(slot, rank);
        slot.generate(ans, upgrade, random);
        return ans;
    }

    @Deprecated
    public ArtifactStats() {
    }

    public ArtifactStats(ArtifactSlot slot, int rank) {
        this.slot = slot;
        this.rank = rank;
    }

    @SerialClass.OnInject
    public void onInject() {
        this.main_stat.init(this.slot);
        this.map.put(this.main_stat.type, this.main_stat);
        for (StatEntry ent : this.sub_stats) {
            ent.init(this.slot);
            this.map.put(ent.type, ent);
        }
    }

    public void add(StatEntry entry) {
        if (this.map.containsKey(entry.type)) {
            return;
        }
        if (this.main_stat == null) {
            this.main_stat = entry;
        } else {
            this.sub_stats.add(entry);
        }
        entry.init(this.slot);
        this.map.put(entry.type, entry);
    }

    public void add(ResourceLocation type, double value) {
        if (this.map.containsKey(type)) {
            this.map.get(type).addMultiplier(value);
        } else {
            this.add(new StatEntry(this.slot, type, value));
        }
    }

    public Multimap<Attribute, AttributeModifier> buildAttributes(String uuidBase) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (StatEntry ent : this.map.values()) {
            ent.getType().getModifier((ImmutableMultimap.Builder<Attribute, AttributeModifier>)builder, ent, UUID.nameUUIDFromBytes((uuidBase + ent.type).getBytes()));
        }
        return builder.build();
    }

    public void addExp(int exp, RandomSource random) {
        int max_exp;
        this.exp += exp;
        int max_level = ArtifactUpgradeManager.getMaxLevel(this.rank);
        while (this.level < max_level && this.exp >= (max_exp = ArtifactUpgradeManager.getExpForLevel(this.rank, this.level))) {
            this.exp -= max_exp;
            ++this.level;
        }
        if (this.level == max_level) {
            this.exp = 0;
        }
    }
}

