/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2artifacts.compat;

import dev.xkmc.l2artifacts.init.data.ArtifactConfig;
import dev.xkmc.l2hostility.content.capability.mob.MobTraitCap;
import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraftforge.fml.ModList;

public class L2HostilityCompat {
    public static boolean validForDrop(LivingEntity e, int min, int max) {
        if (e instanceof Mob) {
            Mob mob = (Mob)e;
            if (ModList.get().isLoaded("l2hostility") && ((Boolean)ArtifactConfig.COMMON.useLevelDropForHostility.get()).booleanValue()) {
                return L2HostilityCompat.validForDropForHostility(mob, min, max);
            }
        }
        if (e instanceof Enemy) {
            float health = e.m_21233_();
            return (double)health + 0.001 > (double)min && (max <= 0 || (double)health + 0.001 < (double)max);
        }
        return false;
    }

    private static boolean validForDropForHostility(Mob e, int min, int max) {
        boolean underLevel;
        Optional opt = e.getCapability(MobTraitCap.CAPABILITY).resolve();
        if (opt.isEmpty()) {
            return false;
        }
        int lv = ((MobTraitCap)opt.get()).getLevel();
        float health = e.m_21233_();
        boolean overHealth = (double)health + 0.001 > (double)min;
        boolean underHealth = (double)health + 0.001 < (double)max;
        boolean overLevel = lv >= min;
        boolean bl = underLevel = lv < max;
        if (!overHealth || !overLevel) {
            return false;
        }
        return max <= 0 || underHealth || underLevel;
    }
}

