/*
 * Decompiled with CFR 0.152.
 */
package com.nakuring.enhanced_boss_bars;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.nakuring.enhanced_boss_bars.BossBarsConfig;
import com.nakuring.enhanced_boss_bars.CustomBarRenderer;
import com.nakuring.enhanced_boss_bars.ModConfigScreen;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod(value="enhanced_boss_bars")
public class EnhancedBossBars {
    public static final String MODID = "enhanced_boss_bars";
    public static final List<String> ModListsID = List.of("mowziesmobs", "cataclysm", "bosses_of_mass_destruction", "witherstormmod", "meetyourfight", "alexsmobs", "aether");
    public static final List<String> ModInstalledIDs = new ArrayList<String>();
    private static final ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
    static final Map<String, String> BossNametoTranslatable = new HashMap<String, String>();

    public EnhancedBossBars() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::onClientSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        EnhancedBossBars.checkInstalledMods();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)BossBarsConfig.COMMON_CONFIG);
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((mc, screen) -> ModConfigScreen.createConfigScreen(screen)));
        BossBarsConfig.LoadConfig();
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new CustomBarRenderer());
    }

    private void onLoadComplete(FMLLoadCompleteEvent event) {
        EnhancedBossBars.loadConfig(FMLPaths.CONFIGDIR.get().resolve("enhanced_boss_bars-common.toml"));
    }

    static void loadConfig(Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        BossBarsConfig.COMMON_CONFIG.setConfig((CommentedConfig)configData);
    }

    public static void checkInstalledMods() {
        ModList modList = ModList.get();
        for (String modID : ModListsID) {
            if (!modList.isLoaded(modID)) continue;
            ModInstalledIDs.add(modID);
        }
        BossNametoTranslatable.put("Ender Dragon", "entity.minecraft.ender_dragon");
        BossNametoTranslatable.put("Wither", "entity.minecraft.wither");
        if (ModInstalledIDs.contains("cataclysm")) {
            BossNametoTranslatable.put("Ignis", "entity.cataclysm.ignis");
            BossNametoTranslatable.put("Ender Guardian", "entity.cataclysm.ender_guardian");
            BossNametoTranslatable.put("Netherite Monstrosity", "entity.cataclysm.netherite_monstrosity");
            BossNametoTranslatable.put("The Harbinger", "entity.cataclysm.the_harbinger");
            BossNametoTranslatable.put("The Leviathan", "entity.cataclysm.the_leviathan");
        }
        if (ModInstalledIDs.contains("bosses_of_mass_destruction")) {
            BossNametoTranslatable.put("Night Lich", "entity.bosses_of_mass_destruction.lich");
            BossNametoTranslatable.put("Nether Gauntlet", "entity.bosses_of_mass_destruction.gauntlet");
            BossNametoTranslatable.put("Void Blossom", "entity.bosses_of_mass_destruction.void_blossom");
            BossNametoTranslatable.put("Obsidilith", "entity.bosses_of_mass_destruction.obsidilith");
        }
        if (ModInstalledIDs.contains("mowziesmobs")) {
            BossNametoTranslatable.put("Ferrous Wroughtnaut", "entity.mowziesmobs.ferrous_wroughtnaut");
            BossNametoTranslatable.put("Frostmaw", "entity.mowziesmobs.frostmaw");
        }
        if (ModInstalledIDs.contains("meetyourfight")) {
            BossNametoTranslatable.put("Bellringer", "entity.meetyourfight.bellringer");
            BossNametoTranslatable.put("Swampjaw", "entity.meetyourfight.swampjaw");
        }
        if (ModInstalledIDs.contains("alexsmobs")) {
            BossNametoTranslatable.put("Void Worm", "entity.alexsmobs.void_worm");
        }
        if (ModInstalledIDs.contains("witherstormmod")) {
            BossNametoTranslatable.put("Wither Storm", "entity.witherstormmod.wither_storm");
        }
        if (ModInstalledIDs.contains("aether")) {
            BossNametoTranslatable.put("Slider", "entity.aether.slider");
            BossNametoTranslatable.put("Sun Spirit", "entity.aether.sun_spirit");
            BossNametoTranslatable.put("Valkyrie Queen", "entity.aether.valkyrie_queen");
        }
    }
}

