/*
 * Decompiled with CFR 0.152.
 */
package net.kayn.fallen_gems_affixes.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.kayn.fallen_gems_affixes.attributes.AAAttributes;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.RegistryObject;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.util.GunModifierHelper;

@Mixin(value={GunModifierHelper.class}, remap=false)
public class GunModifierHelperMixin {
    @Unique
    private static double fallenGemsAffixes$getAttributeValue(ItemStack weapon, RegistryObject<Attribute> attributeRO) {
        return weapon.m_41638_(EquipmentSlot.MAINHAND).get((Object)((Attribute)attributeRO.get())).stream().mapToDouble(AttributeModifier::m_22218_).sum();
    }

    @ModifyReturnValue(method={"getModifiedProjectileSpeed"}, at={@At(value="RETURN")})
    private static double onGetModifiedProjectileSpeed(double originalSpeed, ItemStack weapon, double speed) {
        double modifier = GunModifierHelperMixin.fallenGemsAffixes$getAttributeValue(weapon, AAAttributes.PROJECTILE_SPEED);
        return originalSpeed * (1.0 + modifier);
    }

    @ModifyReturnValue(method={"getKickReduction"}, at={@At(value="RETURN")})
    private static float onGetKickReduction(float originalReduction, ItemStack weapon) {
        double modifier = GunModifierHelperMixin.fallenGemsAffixes$getAttributeValue(weapon, AAAttributes.KICK_REDUCTION);
        return originalReduction + (float)(modifier * (double)(1.0f - originalReduction));
    }

    @ModifyReturnValue(method={"getModifiedRate"}, at={@At(value="RETURN")})
    private static int onGetModifiedRate(int originalRate, ItemStack weapon, int rate) {
        double modifier = GunModifierHelperMixin.fallenGemsAffixes$getAttributeValue(weapon, AAAttributes.FIRE_RATE);
        return (int)((double)originalRate / (1.0 + modifier));
    }

    @ModifyReturnValue(method={"getModifiedAmmoCapacity"}, at={@At(value="RETURN")})
    private static int onGetModifiedAmmoCapacity(int originalCapacity, ItemStack weapon, Gun modifiedGun) {
        double additionalAmmo = GunModifierHelperMixin.fallenGemsAffixes$getAttributeValue(weapon, AAAttributes.ADDITIONAL_AMMO);
        return originalCapacity + (int)additionalAmmo;
    }

    @ModifyReturnValue(method={"getModifiedSpread"}, at={@At(value="RETURN")})
    private static float onGetModifiedSpread(float originalSpread, ItemStack weapon, float spread) {
        double modifier = GunModifierHelperMixin.fallenGemsAffixes$getAttributeValue(weapon, AAAttributes.SPREAD_REDUCTION);
        return originalSpread * (float)(1.0 - modifier);
    }

    @ModifyReturnValue(method={"getModifiedReloadSpeed"}, at={@At(value="RETURN")})
    private static double onGetModifiedReloadSpeed(double originalReloadSpeed, ItemStack weapon, double reloadSpeed) {
        double modifier = GunModifierHelperMixin.fallenGemsAffixes$getAttributeValue(weapon, AAAttributes.RELOAD_SPEED);
        return originalReloadSpeed / (1.0 + modifier);
    }

    @ModifyReturnValue(method={"getModifiedProjectileDamage"}, at={@At(value="RETURN")})
    private static float onGetModifiedProjectileDamage(float originalDamage, ItemStack weapon, float damage) {
        double modifier = GunModifierHelperMixin.fallenGemsAffixes$getAttributeValue(weapon, AAAttributes.BULLET_DAMAGE);
        return originalDamage * (float)(1.0 + modifier);
    }
}

