/*
 * Decompiled with CFR 0.152.
 */
package net.kayn.fallen_gems_affixes.mixin;

import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.Gem;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.bonus.GemBonus;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.kayn.fallen_gems_affixes.adventure.socket.gem.GemBonusExtension;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Gem.class}, remap=false)
public class GemMixin
implements GemBonusExtension {
    @Final
    @Shadow
    protected transient Map<LootCategory, GemBonus> bonusMap;
    @Unique
    private final List<GemBonus> fallen_gems_affixes$extraBonuses = new ArrayList<GemBonus>();

    @Override
    @Unique
    public void fallen_gems_affixes$appendExtraBonus(GemBonus bonus) {
        this.fallen_gems_affixes$validateBonus(bonus);
        this.fallen_gems_affixes$extraBonuses.add(bonus);
        for (LootCategory cat : bonus.getGemClass().types()) {
            this.bonusMap.put(cat, bonus);
        }
    }

    @Override
    public void fallen_gems_affixes$clearExtraBonuses() {
        this.fallen_gems_affixes$extraBonuses.clear();
    }

    @Unique
    private void fallen_gems_affixes$validateBonus(GemBonus bonus) {
        for (LootCategory category : bonus.getGemClass().types()) {
            GemBonus conflict;
            if (!this.bonusMap.containsKey(category) || (conflict = this.bonusMap.get(category)).equals(bonus)) continue;
            throw new IllegalArgumentException("Gem Bonus for class %s conflicts with existing bonus for class %s (categories overlap)".formatted(bonus.getGemClass().key(), conflict.getGemClass().key()));
        }
    }

    @Inject(method={"addInformation"}, at={@At(value="TAIL")}, remap=false)
    private void fallen_gems_affixes$addExtraBonusesTooltips(ItemStack gem, LootRarity rarity, Consumer<Component> list, CallbackInfo ci) {
        for (GemBonus bonus : this.fallen_gems_affixes$extraBonuses) {
            if (!bonus.supports(rarity)) continue;
            Component modifyComp = bonus.getSocketBonusTooltip(gem, rarity);
            MutableComponent sum = Component.m_237110_((String)"text.apotheosis.dot_prefix", (Object[])new Object[]{Component.m_237110_((String)"%s: %s", (Object[])new Object[]{Component.m_237115_((String)("gem_class." + bonus.getGemClass().key())), modifyComp})}).m_130940_(ChatFormatting.GOLD);
            list.accept((Component)sum);
        }
    }
}

