/*
 * Decompiled with CFR 0.152.
 */
package net.kayn.fallen_gems_affixes.init.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.socket.SocketHelper;
import dev.shadowsoffire.apotheosis.adventure.socket.SocketedGems;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemInstance;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemRegistry;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Predicate;
import net.kayn.fallen_gems_affixes.config.ModConfig;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class SocketGemModifier
extends LootModifier {
    public static final Codec<SocketGemModifier> CODEC = RecordCodecBuilder.create(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, SocketGemModifier::new));

    public SocketGemModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (!((Boolean)ModConfig.ENABLE_SOCKET_GEM_MODIFIER.get()).booleanValue()) {
            return generatedLoot;
        }
        RandomSource rand = context.m_230907_();
        ServerLevel level = context.m_78952_();
        for (ItemStack stack : generatedLoot) {
            LootCategory category;
            int sockets;
            if (stack.m_41619_() || (sockets = SocketHelper.getSockets((ItemStack)stack)) <= 0 || (category = LootCategory.forItem((ItemStack)stack)) == null || category.isNone()) continue;
            ArrayList<GemInstance> gems = new ArrayList<GemInstance>(Collections.nCopies(sockets, GemInstance.EMPTY));
            for (int i = 0; i < sockets; ++i) {
                GemInstance instance;
                ItemStack gemStack;
                GemInstance selected = GemInstance.EMPTY;
                if ((double)rand.m_188501_() <= (Double)ModConfig.SOCKET_GEM_CHANCE.get() && !(gemStack = GemRegistry.createRandomGemStack((RandomSource)rand, (ServerLevel)level, (float)1.0f, (Predicate[])new Predicate[]{g -> g.getBonuses().stream().anyMatch(bonus -> bonus.getGemClass() != null && bonus.getGemClass().types().contains(category))})).m_41619_() && (instance = GemInstance.socketed((ItemStack)stack, (ItemStack)gemStack)).isValid()) {
                    selected = instance;
                }
                gems.set(i, selected);
            }
            SocketHelper.setGems((ItemStack)stack, (SocketedGems)new SocketedGems(gems));
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

